/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

public class FutureTask
implements Future,
Runnable {
    private static final int RUNNING = 1;
    private static final int RAN = 2;
    private static final int CANCELLED = 4;
    private final Callable callable;
    private Object result;
    private Throwable exception;
    private int state;
    private volatile Thread runner;

    public synchronized boolean isCancelled() {
        boolean bl = false;
        if (this.state == 4) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isDone() {
        boolean bl = false;
        if (this.ranOrCancelled() && this.runner == null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            Thread r;
            if (this.ranOrCancelled()) {
                return false;
            }
            this.state = 4;
            if (mayInterruptIfRunning && (r = this.runner) != null) {
                r.interrupt();
            }
            this.runner = null;
            this.notifyAll();
        }
        this.done();
        return true;
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        this.waitFor();
        return this.getResult();
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitFor(unit.toNanos(timeout));
        return this.getResult();
    }

    protected void done() {
    }

    protected void set(Object v) {
        this.setCompleted(v);
    }

    protected void setException(Throwable t) {
        this.setFailed(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.setCompleted(this.callable.call());
            return;
        }
        catch (Throwable ex) {
            this.setFailed(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean runAndReset() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return false;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.callable.call();
            FutureTask futureTask2 = this;
            synchronized (futureTask2) {
                this.runner = null;
                if (this.state == 1) {
                    this.state = 0;
                    return true;
                }
                return false;
            }
        }
        catch (Throwable ex) {
            this.setFailed(ex);
            return false;
        }
    }

    private final boolean ranOrCancelled() {
        boolean bl = false;
        if ((this.state & 6) != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setCompleted(Object result) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.result = result;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setFailed(Throwable exception) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.exception = exception;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private final void waitFor() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
    }

    private final void waitFor(long nanos) throws InterruptedException, TimeoutException {
        if (nanos < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isDone()) {
            return;
        }
        long deadline = Utils.nanoTime() + nanos;
        while (nanos > 0L) {
            TimeUnit.NANOSECONDS.timedWait(this, nanos);
            if (this.isDone()) {
                return;
            }
            nanos = deadline - Utils.nanoTime();
        }
        throw new TimeoutException();
    }

    private final Object getResult() throws ExecutionException {
        if (this.state == 4) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
    }

    public FutureTask(Runnable runnable, Object result) {
        this(Executors.callable(runnable, result));
    }
}

