/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataReferenceMaintainer;
import jp.gr.javacons.jim.DataReferencer;
import jp.gr.javacons.jim.DuplicatedNameException;
import jp.gr.javacons.jim.IllegalManagerMemberException;
import jp.gr.javacons.jim.PropertyListPanelForDataHolder;
import org.apache.log4j.Logger;

public class Manager {
    private static final String INVALID_CHARACTER = "$-_.";
    private static Manager _instance = new Manager();
    private Map dataProviders = Collections.synchronizedMap(new HashMap());
    private List unnamedDataProviders = Collections.synchronizedList(new ArrayList());
    private Map dataHolderReferenceMaintainers = Collections.synchronizedMap(new HashMap());
    private static Logger logger = Logger.getLogger((Class)Manager.class);

    private Manager() {
    }

    public void addDataProvider(DataProvider dp) {
        if (this.unnamedDataProviders.contains(dp) || this.dataProviders.containsValue(dp)) {
            throw new IllegalManagerMemberException("DataProvider already exists");
        }
        String dpName = dp.getDataProviderName();
        if (dpName == null || dpName.equals("")) {
            this.unnamedDataProviders.add(dp);
        } else {
            this.dataProviderAvailable(dp, dpName);
        }
    }

    public void addDataReferenceMaintainer(DataReferenceMaintainer rm) {
        if (rm instanceof DataReferencer) {
            DataReferencer dr = (DataReferencer)rm;
            String key = dr.getDataProviderName() + "_" + dr.getDataHolderName();
            if (this.dataHolderReferenceMaintainers.containsKey(key)) {
                List drs = (List)this.dataHolderReferenceMaintainers.get(key);
                if (drs.contains(rm)) {
                    throw new IllegalManagerMemberException("DataReferenceMaintainer already exists");
                }
                drs.add(rm);
                rm.addedAsDataReferenceMaintainer();
            } else {
                ArrayList<DataReferenceMaintainer> rms = new ArrayList<DataReferenceMaintainer>();
                rms.add(rm);
                this.dataHolderReferenceMaintainers.put(key, rms);
                rm.addedAsDataReferenceMaintainer();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)rm);
        }
    }

    public boolean canSetDataProviderName(DataProvider dataProvider, String dataProviderName) {
        if (dataProviderName == null || dataProviderName.equals("")) {
            return true;
        }
        DataProvider dp = (DataProvider)this.dataProviders.get(dataProviderName);
        if (dp == null && !Manager.containsInvalidCharacter(dataProviderName)) {
            return true;
        }
        if (dp == dataProvider) {
            return true;
        }
        if (dataProviderName.equals(dp.getDataProviderName())) {
            return false;
        }
        return !Manager.containsInvalidCharacter(dataProviderName);
    }

    public static boolean containsInvalidCharacter(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || INVALID_CHARACTER.indexOf(c) >= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataProviderAvailable(DataProvider dp, String dpName) {
        if (this.dataProviders.containsKey(dpName)) {
            throw new DuplicatedNameException("DataProvider Name (" + dpName + ") already exists");
        }
        this.dataProviders.put(dpName, dp);
        dp.addedAsDataProvider();
        DataHolder[] dhs = dp.getDataHolders();
        Map map = this.dataHolderReferenceMaintainers;
        synchronized (map) {
            Iterator it = this.dataHolderReferenceMaintainers.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                List drs = (List)this.dataHolderReferenceMaintainers.get(key);
                Iterator it2 = drs.iterator();
                while (it2.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it2.next();
                    dr.dataProviderAvailable(dp, dhs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataProviderRenamed(DataProvider dp, String newName, String oldName) {
        if (this.dataProviders.containsKey(newName)) {
            throw new DuplicatedNameException("DataProvider Name (" + newName + ") already exists");
        }
        this.dataProviders.put(newName, dp);
        Map map = this.dataHolderReferenceMaintainers;
        synchronized (map) {
            Iterator it = this.dataHolderReferenceMaintainers.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                List drs = (List)this.dataHolderReferenceMaintainers.get(key);
                Iterator it2 = drs.iterator();
                while (it2.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it2.next();
                    dr.dataProviderRenamed(dp, newName, oldName);
                }
            }
        }
        this.dataProviders.remove(oldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataProviderRevoked(DataProvider dp, String dpName) {
        this.dataProviders.remove(dpName);
        dp.removedAsDataProvider();
        DataHolder[] dhs = dp.getDataHolders();
        Map map = this.dataHolderReferenceMaintainers;
        synchronized (map) {
            Iterator it = this.dataHolderReferenceMaintainers.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                List drs = (List)this.dataHolderReferenceMaintainers.get(key);
                Iterator it2 = drs.iterator();
                while (it2.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it2.next();
                    dr.dataProviderRevoked(dp, dhs);
                }
            }
        }
    }

    public DataHolder findDataHolder(String dataHolderID) {
        if (dataHolderID == null) {
            return null;
        }
        int index = dataHolderID.indexOf("_");
        String dpName = dataHolderID.substring(0, index);
        String dhName = dataHolderID.substring(index + 1);
        return this.findDataHolder(dpName, dhName);
    }

    public DataHolder findDataHolder(String dataProviderName, String dataHolderName) {
        return this.findDataHolder(this.getDataProvider(dataProviderName), dataHolderName);
    }

    public DataHolder findDataHolder(DataProvider dp, String dataHolderName) {
        if (dp == null || dataHolderName == null) {
            return null;
        }
        return dp.getDataHolder(dataHolderName);
    }

    public static Component getDataHolderPropertyListPanel(DataHolder dh) {
        Component c = null;
        DataProvider dp = dh.getDataProvider();
        try {
            BeanInfo bi = Introspector.getBeanInfo(dp.getClass());
            Class<?> customizerC = bi.getBeanDescriptor().getCustomizerClass();
            if (customizerC != null) {
                c = (Component)customizerC.newInstance();
                ((Customizer)((Object)c)).setObject(dh);
            }
        }
        catch (Exception e) {
            c = null;
        }
        if (c == null) {
            c = new PropertyListPanelForDataHolder();
            ((PropertyListPanelForDataHolder)c).setTarget(dh);
            if (!dp.canEditDataHolderByUser(dh)) {
                c.setEnabled(false);
            }
        }
        return c;
    }

    public DataProvider getDataProvider(String dataProviderName) {
        if (dataProviderName == null) {
            return null;
        }
        return (DataProvider)this.dataProviders.get(dataProviderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProvider[] getDataProviders() {
        Map map = this.dataProviders;
        synchronized (map) {
            return this.dataProviders.values().toArray(new DataProvider[0]);
        }
    }

    public String getDefaultDataHolderTypeString(Class dataHolderClass, Class valueClass) {
        BeanInfo bi = null;
        try {
            Class<?> biC = Class.forName(dataHolderClass.getName() + "BeanInfo");
            bi = (BeanInfo)biC.newInstance();
        }
        catch (Exception ex) {
            bi = null;
        }
        if (bi != null) {
            return bi.getBeanDescriptor().getDisplayName();
        }
        String dhClassName = null;
        dhClassName = dataHolderClass == DataHolder.class ? "DataHolder" : dataHolderClass.getName();
        String javaLang = "java.lang.";
        String vClassName = valueClass.getName();
        if (vClassName.startsWith(javaLang)) {
            vClassName = vClassName.substring(javaLang.length());
        }
        return dhClassName + "(" + vClassName + ")";
    }

    public static Manager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataHolderAvailable(DataProvider dp, DataHolder[] dhs) {
        if (!this.dataProviders.containsValue(dp)) {
            return;
        }
        for (int i = 0; i < dhs.length; ++i) {
            if (!this.dataHolderReferenceMaintainers.containsKey(dhs[i])) continue;
            Map map = this.dataHolderReferenceMaintainers;
            synchronized (map) {
                List drs = (List)this.dataHolderReferenceMaintainers.get(dhs[i]);
                Iterator it = drs.iterator();
                while (it.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(new Date() + " notifyDataHolderAvailable : " + dr));
                    }
                    dr.dataHolderAvailable(dp, dhs);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataHolderRenamed(DataProvider dp, DataHolder dh, String newName, String oldName) {
        if (!this.dataProviders.containsValue(dp)) {
            return;
        }
        if (this.dataHolderReferenceMaintainers.containsKey(this.getReferencerKey(dp, dh))) {
            Map map = this.dataHolderReferenceMaintainers;
            synchronized (map) {
                List drs = (List)this.dataHolderReferenceMaintainers.get(dh);
                Iterator it = drs.iterator();
                while (it.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it.next();
                    dr.dataHolderRenamed(dp, dh, newName, oldName);
                }
            }
        }
    }

    private String getReferencerKey(DataProvider dp, DataHolder dh) {
        return dp.getDataProviderName() + "_" + dh.getDataHolderName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDataHolderRevoked(DataProvider dp, DataHolder[] dhs) {
        if (!this.dataProviders.containsValue(dp)) {
            return;
        }
        for (int i = 0; i < dhs.length; ++i) {
            DataHolder dh = dhs[i];
            String key = this.getReferencerKey(dp, dh);
            if (!this.dataHolderReferenceMaintainers.containsKey(key)) continue;
            List drs = (List)this.dataHolderReferenceMaintainers.get(key);
            Map map = this.dataHolderReferenceMaintainers;
            synchronized (map) {
                Iterator it = drs.iterator();
                while (it.hasNext()) {
                    DataReferenceMaintainer dr = (DataReferenceMaintainer)it.next();
                    dr.dataHolderRevoked(dp, dhs);
                }
                continue;
            }
        }
    }

    public void notifyDataProviderRenamed(DataProvider dp, String newName, String oldName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("provider :  old : " + oldName + " new : " + newName));
        }
        if (this.unnamedDataProviders.contains(dp)) {
            if (newName != null && !newName.equals("")) {
                this.unnamedDataProviders.remove(dp);
                this.dataProviderAvailable(dp, newName);
            }
        } else if (this.dataProviders.containsKey(oldName)) {
            if (newName == null || newName.equals("")) {
                this.dataProviderRevoked(dp, oldName);
                this.unnamedDataProviders.add(dp);
            } else {
                this.dataProviderRenamed(dp, newName, oldName);
            }
        }
    }

    public void removeDataProvider(DataProvider dp) {
        if (this.unnamedDataProviders.contains(dp)) {
            this.unnamedDataProviders.remove(dp);
        } else if (this.dataProviders.containsValue(dp)) {
            this.dataProviderRevoked(dp, dp.getDataProviderName());
        }
    }

    public void removeDataReferenceMaintainer(DataReferenceMaintainer rm) {
        if (rm instanceof DataReferencer) {
            DataReferencer dr = (DataReferencer)rm;
            String key = dr.getDataProviderName() + "_" + dr.getDataHolderName();
            if (this.dataHolderReferenceMaintainers.containsKey(key)) {
                List drs = (List)this.dataHolderReferenceMaintainers.get(key);
                drs.remove(rm);
                rm.removedAsDataReferenceMaintainer();
                if (drs.size() == 0) {
                    this.dataHolderReferenceMaintainers.remove(key);
                }
            }
        } else {
            logger.info((Object)rm.getClass().getName());
        }
    }

    public boolean hasReferenceMaintainer(DataReferenceMaintainer rm) {
        DataReferencer dr;
        String key;
        if (rm instanceof DataReferencer && this.dataHolderReferenceMaintainers.containsKey(key = (dr = (DataReferencer)rm).getDataProviderName() + "_" + dr.getDataHolderName())) {
            List drs = (List)this.dataHolderReferenceMaintainers.get(key);
            return drs.contains(rm);
        }
        return false;
    }
}

