/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

public class MockInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6438214603532050462L;
    private Map returnValueMap_ = new HashMap();
    private Map throwableMap_ = new HashMap();
    private Map invokedMap_ = new HashMap();
    private Map argsMap_ = new HashMap();

    public MockInterceptor() {
    }

    public MockInterceptor(Object value) {
        this.setReturnValue(value);
    }

    public void setReturnValue(Object returnValue) {
        this.setReturnValue(null, returnValue);
    }

    public void setReturnValue(String methodName, Object returnValue) {
        this.returnValueMap_.put(methodName, returnValue);
    }

    public void setThrowable(Throwable throwable) {
        this.setThrowable(null, throwable);
    }

    public void setThrowable(String methodName, Throwable throwable) {
        this.throwableMap_.put(methodName, throwable);
    }

    public boolean isInvoked(String methodName) {
        return this.invokedMap_.containsKey(methodName);
    }

    public Object[] getArgs(String methodName) {
        return (Object[])this.argsMap_.get(methodName);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        this.invokedMap_.put(invocation.getMethod().getName(), Boolean.TRUE);
        this.argsMap_.put(methodName, invocation.getArguments());
        if (this.throwableMap_.containsKey(methodName)) {
            throw (Throwable)this.throwableMap_.get(methodName);
        }
        if (this.throwableMap_.containsKey(null)) {
            throw (Throwable)this.throwableMap_.get(null);
        }
        if (this.returnValueMap_.containsKey(methodName)) {
            return this.returnValueMap_.get(methodName);
        }
        return this.returnValueMap_.get(null);
    }
}

