/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.io.Serializable;
import java.util.Date;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataReferenceMaintainer;
import jp.gr.javacons.jim.DataReferencerOwner;
import jp.gr.javacons.jim.DataReferencerStatusMonitor;
import jp.gr.javacons.jim.DataValueChangeEvent;
import jp.gr.javacons.jim.DataValueChangeListener;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.QualityFlag;
import org.apache.log4j.Logger;

public class DataReferencer
implements DataReferenceMaintainer,
Serializable {
    static final long serialVersionUID = 7456763300083627405L;
    private transient DataReferencerOwner owner;
    private String dataProviderName = "";
    private String dataHolderName = "";
    private transient DataHolder dataHolder;
    private transient Manager manager;
    private static Logger logger = Logger.getLogger((Class)DataReferencer.class);

    public DataReferencer(String dataProviderName, String dataHolderName) {
        this.dataProviderName = dataProviderName;
        this.dataHolderName = dataHolderName;
    }

    public DataReferencer(DataReferencerOwner owner) {
        this("", "");
        this.owner = owner;
    }

    public void addedAsDataReferenceMaintainer() {
        this.manager = Manager.getInstance();
        this.dataHolder = this.manager.findDataHolder(this.dataProviderName, this.dataHolderName);
        if (this.dataHolder != null) {
            this.registerListeners();
        }
    }

    public void connect(DataReferencerOwner jimGUI) {
        if (this.manager != null) {
            return;
        }
        if (this.dataHolder != null) {
            return;
        }
        if (jimGUI == null) {
            return;
        }
        this.owner = jimGUI;
        Manager.getInstance().addDataReferenceMaintainer(this);
    }

    public void dataHolderAvailable(DataProvider dp, DataHolder[] dhs) {
        if (this.dataProviderName == null || this.dataHolderName == null) {
            return;
        }
        if (!this.dataProviderName.equals(dp.getDataProviderName())) {
            return;
        }
        for (int i = 0; i < dhs.length; ++i) {
            DataHolder dh = dhs[i];
            if (!this.dataHolderName.equals(dh.getDataHolderName())) continue;
            this.dataHolder = dh;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("holder:" + dh));
            }
            this.registerListeners();
            break;
        }
    }

    public void dataHolderRenamed(DataProvider dp, DataHolder dh, String newName, String oldName) {
        if (this.dataHolderName == null || this.dataProviderName == null || !this.dataProviderName.equals(dp.getDataProviderName())) {
            return;
        }
        if (this.dataHolderName.equals(oldName)) {
            this.dataHolderName = dh.getDataHolderName();
        } else if (this.dataHolderName.equals(newName) && this.dataHolder == null) {
            this.dataHolder = dh;
            this.registerListeners();
        }
    }

    public void dataHolderRevoked(DataProvider dp, DataHolder[] dhs) {
        if (this.dataHolder == null) {
            return;
        }
        for (int i = 0; i < dhs.length; ++i) {
            if (this.dataHolder != dhs[i]) continue;
            this.deregisterListeners();
            this.dataHolder = null;
            break;
        }
    }

    public void dataProviderAvailable(DataProvider dp, DataHolder[] dhs) {
        this.dataHolderAvailable(dp, dhs);
    }

    public void dataProviderRenamed(DataProvider dp, String newName, String oldName) {
        if (this.dataProviderName == null) {
            return;
        }
        if (this.dataProviderName.equals(oldName)) {
            this.dataProviderName = newName;
        } else if (this.dataProviderName.equals(newName) && this.dataHolderName != null && this.dataHolder == null) {
            this.dataHolder = this.manager.findDataHolder(this.dataProviderName, this.dataHolderName);
            if (this.dataHolder != null) {
                this.registerListeners();
            }
        }
    }

    public void dataProviderRevoked(DataProvider dp, DataHolder[] dhs) {
        this.dataHolderRevoked(dp, dhs);
    }

    private void deregisterListeners() {
        if (this.owner instanceof DataReferencerStatusMonitor) {
            if (this.owner instanceof DataValueChangeListener) {
                DataValueChangeListener vLis = (DataValueChangeListener)((Object)this.owner);
                this.dataHolder.removeDataValueChangeListener(vLis);
            }
            ((DataReferencerStatusMonitor)((Object)this.owner)).dataReferencerConnected(this, this.dataHolder, false);
        } else if (this.owner instanceof DataValueChangeListener) {
            DataValueChangeListener vLis = (DataValueChangeListener)((Object)this.owner);
            this.dataHolder.removeDataValueChangeListener(vLis);
        }
    }

    public void disconnect(DataReferencerOwner jimGUI) {
        if (this.manager == null) {
            return;
        }
        this.manager.removeDataReferenceMaintainer(this);
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    public String getDataHolderName() {
        return this.dataHolderName;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    public Class[][] getReferableDataHolderTypeInfo() {
        if (this.owner == null) {
            return new Class[0][];
        }
        return this.owner.getReferableDataHolderTypeInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListeners() {
        if (this.owner instanceof DataReferencerStatusMonitor) {
            if (this.owner instanceof DataValueChangeListener) {
                DataValueChangeListener vLis = (DataValueChangeListener)((Object)this.owner);
                this.dataHolder.addDataValueChangeListener(vLis);
            }
            ((DataReferencerStatusMonitor)((Object)this.owner)).dataReferencerConnected(this, this.dataHolder, true);
        } else if (this.owner instanceof DataValueChangeListener) {
            QualityFlag fg;
            Date ts;
            Object val;
            DataValueChangeListener vLis = (DataValueChangeListener)((Object)this.owner);
            this.dataHolder.addDataValueChangeListener(vLis);
            DataHolder dataHolder = this.dataHolder;
            synchronized (dataHolder) {
                val = this.dataHolder.getValue();
                ts = this.dataHolder.getTimeStamp();
                fg = this.dataHolder.getQualityFlag();
            }
            vLis.dataValueChanged(new DataValueChangeEvent(this.dataHolder, val, ts, fg));
        }
    }

    public void removedAsDataReferenceMaintainer() {
        if (this.dataHolder != null) {
            this.deregisterListeners();
            this.dataHolder = null;
        }
        this.manager = null;
        this.owner = null;
    }

    public void setDataHolderID(String dataProviderName, String dataHolderName) {
        if (dataProviderName != null && dataHolderName != null && dataProviderName.equals(this.dataProviderName) && dataHolderName.equals(this.dataHolderName)) {
            return;
        }
        if (this.owner != null) {
            DataReferencerOwner owner = this.owner;
            this.disconnect(owner);
            this.dataProviderName = dataProviderName;
            this.dataHolderName = dataHolderName;
            this.connect(owner);
        } else {
            this.dataProviderName = dataProviderName;
            this.dataHolderName = dataHolderName;
        }
    }

    public String toString() {
        String s = "DataReferencer: \"" + this.dataProviderName + "." + this.dataHolderName + "\" ";
        s = s + "{";
        Class[][] info = this.getReferableDataHolderTypeInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                s = s + "{";
                Class[] dht = info[i];
                for (int j = 0; j < dht.length; ++j) {
                    s = s + dht[j].toString() + ",";
                }
                s = s + "},";
            }
        }
        s = s + "}";
        return s;
    }
}

