/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final LockInfo lock;

    public void awaitUninterruptibly() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.await();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock.lock();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    if (nanos > 0L) {
                        long start = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        boolean bl = false;
                        if (Utils.nanoTime() - start < nanos) {
                            bl = true;
                        }
                        success = bl;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.lock.lock();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.lock.lock();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    long start = System.currentTimeMillis();
                    long msecs = abstime - start;
                    if (msecs > 0L) {
                        this.wait(msecs);
                        boolean bl = false;
                        if (System.currentTimeMillis() - start < msecs) {
                            bl = true;
                        }
                        success = bl;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.lock.lock();
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        this.lock.lock();
        return success;
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    CondVar(LockInfo lock) {
        this.lock = lock;
    }

    static interface LockInfo
    extends Lock {
        public boolean isHeldByCurrentThread();
    }
}

