/*
 * 쐬: 2004/06/14 ̐ꂽRg̑}ev[gύX邽 EBhE > ݒ > Java > R[h >
 * R[hƃRg
 */
package org.F11.scada.tool.page.parser.bar2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.F11.scada.tool.io.PointItemStore;
import org.F11.scada.tool.io.StrategyUtility;
import org.F11.scada.tool.page.bar2.Bar2PointForm;
import org.F11.scada.tool.page.parser.DOMPageDefine;
import org.F11.scada.tool.point.name.PointNameBean;
import org.F11.scada.util.ConnectionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * @author hori ̐ꂽRg̑}ev[gύX邽 EBhE > ݒ > Java > R[h >
 *         R[hƃRg
 */
public class BarGraph2Define {
	private final Document document;
	private final Element element;

	public BarGraph2Define(Document document, Element element) {
		this.document = document;
		this.element = element;
	}

	public void setBarPoint(Bar2PointForm form) {
		NodeList seriesList = element.getElementsByTagNameNS(
				DOMPageDefine.NAME_SPACE, "barseries");
		for (int i = 0; i < seriesList.getLength(); i++) {
			Element seriesElement = (Element) seriesList.item(i);
			String value = seriesElement.getAttribute("name");
			int p1 = value.indexOf("$(");
			int p2 = value.indexOf('_', p1);
			if (0 <= p1 && p1 < p2) {
				int refPoint = Integer.parseInt(value.substring(p1 + 2, p2));
				if (refPoint == form.getPoint()) {
					NodeList propertyList = seriesElement.getElementsByTagNameNS(
							DOMPageDefine.NAME_SPACE, "barprop");
					for (int j = 0; j < propertyList.getLength(); j++) {
						Element propertyElement = (Element) propertyList.item(j);
						propertyElement.setAttribute("minimums",
								String.valueOf(form.getMinimums(j)));
						propertyElement.setAttribute("maximums",
								String.valueOf(form.getMaximums(j)));
					}
					break;
				}
			}
		}
	}

	public Bar2PointForm getBarPoint(int point) throws SQLException,
			IOException {
		Bar2PointForm bean = new Bar2PointForm();
		NodeList modelList = element.getElementsByTagNameNS(
				DOMPageDefine.NAME_SPACE, "bargraphmodel");
		String[] model_names = new String[modelList.getLength()];
		for (int i = 0; i < modelList.getLength(); i++) {
			Element modelElement = (Element) modelList.item(i);
			model_names[i] = modelElement.getAttribute("text");
		}
		bean.setModel_names(model_names);

		NodeList seriesList = element.getElementsByTagNameNS(
				DOMPageDefine.NAME_SPACE, "barseries");
		for (int i = 0; i < seriesList.getLength(); i++) {
			Element seriesElement = (Element) seriesList.item(i);
			String value = seriesElement.getAttribute("name");
			int p1 = value.indexOf("$(");
			int p2 = value.indexOf('_', p1);
			if (0 <= p1 && p1 < p2) {
				int refPoint = Integer.parseInt(value.substring(p1 + 2, p2));
				if (refPoint == point) {
					bean.setPoint(point);
					NodeList propertyList = seriesElement.getElementsByTagNameNS(
							DOMPageDefine.NAME_SPACE, "barprop");
					for (int j = 0; j < propertyList.getLength(); j++) {
						Element propertyElement = (Element) propertyList.item(j);
						bean.setMinimums(
								j,
								Long.parseLong(propertyElement.getAttribute("minimums")));
						bean.setMaximums(
								j,
								Long.parseLong(propertyElement.getAttribute("maximums")));
					}

					Connection con = null;
					try {
						con = ConnectionUtil.getConnection();
						StrategyUtility util = new StrategyUtility(con);
						PointItemStore store = new PointItemStore();

						PointNameBean nameBean = store.getPointName(util,
								bean.getPoint());
						bean.setUnit(nameBean.getUnit());
						bean.setName(nameBean.getName());
						bean.setUnit_mark(nameBean.getUnit_mark());

						con.close();
						con = null;
					} finally {
						if (con != null) {
							try {
								con.close();
							} catch (SQLException e) {
								con = null;
							}
						}
					}
					break;
				}
			}
		}
		return bean;
	}

	public List<Bar2PointForm> getBarGroup() throws SQLException, IOException {
		List<Bar2PointForm> ret = getPropertyList();
		setPointName(ret);
		return ret;
	}

	private List<Bar2PointForm> getPropertyList() {
		NodeList modelList = element.getElementsByTagNameNS(
				DOMPageDefine.NAME_SPACE, "bargraphmodel");
		String[] model_names = new String[modelList.getLength()];
		for (int i = 0; i < modelList.getLength(); i++) {
			Element modelElement = (Element) modelList.item(i);
			model_names[i] = modelElement.getAttribute("text");
		}

		List<Bar2PointForm> ret = new ArrayList<Bar2PointForm>();
		NodeList seriesList = element.getElementsByTagNameNS(
				DOMPageDefine.NAME_SPACE, "barseries");
		for (int i = 0; i < seriesList.getLength(); i++) {
			Bar2PointForm bean = new Bar2PointForm();
			bean.setModel_names(model_names);
			Element seriesElement = (Element) seriesList.item(i);
			String value = seriesElement.getAttribute("name");
			int p1 = value.indexOf("$(");
			int p2 = value.indexOf('_', p1);
			if (0 <= p1 && p1 < p2) {
				bean.setPoint(Integer.parseInt(value.substring(p1 + 2, p2)));
			}
			NodeList propertyList = seriesElement.getElementsByTagNameNS(
					DOMPageDefine.NAME_SPACE, "barprop");
			for (int j = 0; j < propertyList.getLength(); j++) {
				Element propertyElement = (Element) propertyList.item(j);
				bean.setMinimums(
						j,
						Long.parseLong(propertyElement.getAttribute("minimums")));
				bean.setMaximums(
						j,
						Long.parseLong(propertyElement.getAttribute("maximums")));
			}
			ret.add(bean);
		}
		return ret;
	}

	private void setPointName(List<Bar2PointForm> properties)
			throws SQLException, IOException {

		Connection con = null;
		try {
			con = ConnectionUtil.getConnection();
			StrategyUtility util = new StrategyUtility(con);
			PointItemStore store = new PointItemStore();

			for (Bar2PointForm bean : properties) {
				PointNameBean nameBean = store.getPointName(util,
						bean.getPoint());
				bean.setUnit(nameBean.getUnit());
				bean.setName(nameBean.getName());
				bean.setUnit_mark(nameBean.getUnit_mark());
			}

			con.close();
			con = null;
		} finally {
			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					con = null;
				}
			}
		}
	}

}
