/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeDocumentFactory;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.util.AttributeHelper;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class SchemaParser {
    private static final Namespace XSD_NAMESPACE = Namespace.get("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ELEMENT = QName.get("element", XSD_NAMESPACE);
    private static final QName XSD_ATTRIBUTE = QName.get("attribute", XSD_NAMESPACE);
    private static final QName XSD_SIMPLETYPE = QName.get("simpleType", XSD_NAMESPACE);
    private static final QName XSD_COMPLEXTYPE = QName.get("complexType", XSD_NAMESPACE);
    private static final QName XSD_RESTRICTION = QName.get("restriction", XSD_NAMESPACE);
    private static final QName XSD_SEQUENCE = QName.get("sequence", XSD_NAMESPACE);
    private DatatypeDocumentFactory documentFactory;
    private Map dataTypeCache = new HashMap();

    public SchemaParser() {
        this.documentFactory = DatatypeDocumentFactory.singleton;
    }

    public SchemaParser(DatatypeDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void build(Document schemaDocument) {
        Element root = schemaDocument.getRootElement();
        if (root != null) {
            Iterator iter = root.elementIterator(XSD_ELEMENT);
            while (iter.hasNext()) {
                this.onDatatypeElement((Element)iter.next());
            }
        }
    }

    protected XSDatatype dataTypeForXsdAttribute(Element xsdAttribute) {
        String type = xsdAttribute.attributeValue("type");
        XSDatatype dataType = null;
        if (type != null) {
            dataType = this.getTypeByName(type);
        } else {
            Element xsdSimpleType = xsdAttribute.element(XSD_SIMPLETYPE);
            if (xsdSimpleType == null) {
                String name = xsdAttribute.attributeValue("name");
                throw new InvalidSchemaException("The attribute: " + name + " has no type attribute and does not contain a <simpleType/> element");
            }
            dataType = this.loadXSDatatypeFromSimpleType(xsdSimpleType);
        }
        return dataType;
    }

    protected XSDatatype deriveSimpleType(XSDatatype baseType, Element xsdRestriction) {
        TypeIncubator incubator = new TypeIncubator(baseType);
        ValidationContext context = null;
        try {
            Iterator iter = xsdRestriction.elementIterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String name = element.getName();
                String value = element.attributeValue("value");
                boolean fixed = AttributeHelper.booleanValue(element, "fixed");
                incubator.add(name, value, fixed, context);
            }
            String newTypeName = null;
            return incubator.derive(newTypeName);
        }
        catch (DatatypeException e) {
            this.onSchemaError("Invalid restriction: " + e.getMessage() + " when trying to build restriction: " + xsdRestriction);
            return null;
        }
    }

    protected DatatypeElementFactory getDatatypeElementFactory(QName elementQName) {
        DatatypeElementFactory factory = this.documentFactory.getElementFactory(elementQName);
        if (factory == null) {
            factory = new DatatypeElementFactory(elementQName);
            elementQName.setDocumentFactory(factory);
        }
        return factory;
    }

    protected QName getQName(String name) {
        return this.documentFactory.createQName(name);
    }

    protected XSDatatype getTypeByName(String type) {
        XSDatatype dataType = (XSDatatype)this.dataTypeCache.get(type);
        if (dataType == null) {
            int idx;
            dataType = DatatypeFactory.getTypeByName((String)type);
            if (dataType == null && (idx = type.indexOf(58)) >= 0) {
                String localName = type.substring(idx + 1);
                dataType = DatatypeFactory.getTypeByName((String)localName);
            }
            this.dataTypeCache.put(type, dataType);
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected XSDatatype loadXSDatatypeFromSimpleType(Element xsdSimpleType) {
        Element xsdRestriction = xsdSimpleType.element(XSD_RESTRICTION);
        if (xsdRestriction != null) {
            String base = xsdRestriction.attributeValue("base");
            if (base != null) {
                XSDatatype baseType = this.getTypeByName(base);
                if (baseType != null) return this.deriveSimpleType(baseType, xsdRestriction);
                this.onSchemaError("Invalid base type: " + base + " when trying to build restriction: " + xsdRestriction);
                return null;
            } else {
                Element xsdSubType = xsdSimpleType.element(XSD_SIMPLETYPE);
                if (xsdSubType != null) return this.loadXSDatatypeFromSimpleType(xsdSubType);
                this.onSchemaError("The simpleType element: " + xsdSimpleType + " must contain a base attribute or simpleType element");
            }
            return null;
        } else {
            this.onSchemaError("No <restriction>. Could not create XSDatatype for simpleType: " + xsdSimpleType);
        }
        return null;
    }

    protected void onDatatypeAttribute(Element xsdElement, DatatypeElementFactory elementFactory, Element xsdAttribute) {
        String name = xsdAttribute.attributeValue("name");
        QName qname = this.getQName(name);
        XSDatatype dataType = this.dataTypeForXsdAttribute(xsdAttribute);
        if (dataType != null) {
            elementFactory.setAttributeXSDatatype(qname, dataType);
        } else {
            String type = xsdAttribute.attributeValue("type");
            System.out.println("Warning: Couldn't find XSDatatype for type: " + type + " attribute: " + name);
        }
    }

    protected void onDatatypeElement(Element xsdElement) {
        Iterator iter;
        Element schemaComplexType;
        XSDatatype dataType;
        String name = xsdElement.attributeValue("name");
        String type = xsdElement.attributeValue("type");
        QName qname = this.getQName(name);
        DatatypeElementFactory elementFactory = this.getDatatypeElementFactory(qname);
        if (type != null && (dataType = this.getTypeByName(type)) != null) {
            elementFactory.setChildElementXSDatatype(qname, dataType);
        }
        if ((schemaComplexType = xsdElement.element(XSD_COMPLEXTYPE)) != null) {
            this.onSchemaComplexType(schemaComplexType, elementFactory);
        }
        if ((iter = xsdElement.elementIterator(XSD_ATTRIBUTE)).hasNext()) {
            do {
                this.onDatatypeAttribute(xsdElement, elementFactory, (Element)iter.next());
            } while (iter.hasNext());
        }
    }

    protected void onSchemaComplexType(Element schemaComplexType, DatatypeElementFactory elementFactory) {
        Iterator iter = schemaComplexType.elementIterator(XSD_ATTRIBUTE);
        while (iter.hasNext()) {
            Element xsdAttribute = (Element)iter.next();
            String name = xsdAttribute.attributeValue("name");
            QName qname = this.getQName(name);
            XSDatatype dataType = this.dataTypeForXsdAttribute(xsdAttribute);
            if (dataType != null) {
                elementFactory.setChildElementXSDatatype(qname, dataType);
                elementFactory.setAttributeXSDatatype(qname, dataType);
                continue;
            }
            String type = xsdAttribute.attributeValue("type");
            System.out.println("Warning: Couldn't find XSDatatype for type: " + type + " attribute: " + name);
        }
        Element schemaSequence = schemaComplexType.element(XSD_SEQUENCE);
        if (schemaSequence != null) {
            Iterator iter2 = schemaSequence.elementIterator(XSD_ELEMENT);
            while (iter2.hasNext()) {
                Element xsdElement = (Element)iter2.next();
                this.onDatatypeElement(xsdElement);
            }
        }
    }

    protected void onSchemaError(String message) {
        throw new InvalidSchemaException(message);
    }
}

