/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.compdh;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jp.gr.javacons.jim.AbstractDataProvider;
import jp.gr.javacons.jim.AsyncCompleteMonitor;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataHolderGroup;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jimx.compdh.ComposingEngine;
import jp.gr.javacons.jimx.compdh.CompositeValue;
import jp.gr.javacons.jimx.compdh.DataReferencerContainer;
import jp.gr.javacons.jimx.compdh.EventComposer;

public class CompositeDataHolder
extends AbstractDataProvider {
    static final long serialVersionUID = 6095751205532901656L;
    private DataReferencerContainer container;
    private EventComposer composer;
    private CompositeDataHolderGroup dhGroup = null;
    private final Class[][] DH_TYPE = new Class[][]{{DataReferencerContainer.class, CompositeValue.class}};

    public CompositeDataHolder() {
        this.composer = new EventComposer();
        this.iconName = "CompositeDataHolder32.gif";
        this.container = new DataReferencerContainer();
        this.container.setValueClass(CompositeValue.class);
        this.container.setDataHolderName("container");
        try {
            this.addDataHolder(this.container);
        }
        catch (DataProviderDoesNotSupportException e) {
            System.out.println("CompositeDataHolder constructor fail: addDataHolder");
        }
        this.composer.setContainer(this.container);
    }

    public void addNotify() {
        super.addNotify();
        this.container.connectAll(this.composer);
    }

    public void removeNotify() {
        this.container.disconnectAll(this.composer);
        super.removeNotify();
    }

    public Class[][] getProvidableDataHolderTypeInfo() {
        return this.DH_TYPE;
    }

    public boolean canAddDataHolderByUser() {
        return false;
    }

    public boolean canEditDataHolderByUser(DataHolder dh) {
        return false;
    }

    public boolean canRemoveDataHolderByUser(DataHolder dh) {
        return false;
    }

    public void asyncRead(final DataHolder dh) {
        Thread th = new Thread(){

            public void run() {
                CompositeDataHolder.this.syncRead(dh);
            }
        };
        th.start();
    }

    public void asyncRead(final DataHolder[] dhArray) {
        Thread th = new Thread(){

            public void run() {
                CompositeDataHolder.this.syncRead(dhArray);
            }
        };
        th.start();
    }

    public void asyncRead(DataHolderGroup dhGroup) {
        this.asyncRead(dhGroup, null);
    }

    public void asyncRead(final DataHolderGroup dhGroup, final AsyncCompleteMonitor monitor) {
        Thread th = new Thread(){

            public void run() {
                CompositeDataHolder.this.syncRead(dhGroup);
                if (monitor != null) {
                    monitor.asyncCompleted();
                }
            }
        };
        th.start();
    }

    public void syncRead(DataHolder[] dhArray) {
        for (int i = 0; i < dhArray.length; ++i) {
            this.syncRead(dhArray[i]);
        }
    }

    public void syncRead(DataHolderGroup dhGroup) {
        this.composer.resetEventFlags();
        this.syncRead(dhGroup.getDataHolders());
    }

    public void syncRead(DataHolder dh) {
        if (dh == this.container) {
            Enumeration e = this.container.getDataHolders();
            while (e.hasMoreElements()) {
                DataHolder memberDH = (DataHolder)e.nextElement();
                try {
                    memberDH.syncRead();
                }
                catch (DataProviderDoesNotSupportException ex) {
                    System.out.println(ex);
                }
            }
        } else {
            System.out.println("CompositeDataHolder.syncRead error");
        }
    }

    public DataHolderGroup createReadGroup(DataHolder[] dhArray) {
        if (dhArray[0] != this.container) {
            System.out.println("CompositeDataHolder.createReadGroup error");
            return null;
        }
        if (this.dhGroup == null) {
            this.dhGroup = new CompositeDataHolderGroup();
        }
        return this.dhGroup;
    }

    public void deleteReadGroup(DataHolderGroup dhGroup) {
    }

    public void deleteAllGroup() {
    }

    public void addMember(DataHolder dh) {
        if (this.container.getMember(dh) == null) {
            if (dh != this.container) {
                this.container.addMember(dh);
                this.composer.addMember(this.container.getMember(dh));
            } else {
                System.out.println("CompositeDataHolder :can't add my container.");
            }
        }
    }

    public void removeMember(DataHolder dh) {
        this.composer.removeMember(this.container.getMember(dh));
    }

    public void removeAllMembers() {
        Enumeration e = this.container.getDataHolders();
        while (e.hasMoreElements()) {
            DataHolder dh = (DataHolder)e.nextElement();
            this.removeMember(dh);
        }
    }

    public void setComposingEngine(ComposingEngine engine) {
        this.composer.setComposingEngine(engine);
    }

    public ComposingEngine getComposingEngine() {
        return this.composer.getComposingEngine();
    }

    public Vector getMembers() {
        Vector<DataHolder> dataHolders = new Vector<DataHolder>();
        Enumeration e = this.container.getDataHolders();
        while (e.hasMoreElements()) {
            DataHolder dh = (DataHolder)e.nextElement();
            dataHolders.addElement(dh);
        }
        return dataHolders;
    }

    public void setMembers(Vector dataHolders) {
        this.removeAllMembers();
        for (int i = 0; i < dataHolders.size(); ++i) {
            this.addMember((DataHolder)dataHolders.elementAt(i));
        }
    }

    private class CompositeDataHolderGroup
    implements DataHolderGroup,
    Serializable {
        private static final long serialVersionUID = -8600449408188650671L;
        DataHolder[] dataHolders = new DataHolder[1];

        CompositeDataHolderGroup() {
            this.dataHolders[0] = CompositeDataHolder.this.container;
        }

        public DataHolder[] getDataHolders() {
            return this.dataHolders;
        }
    }
}

