fcf.module({
  name: "fcf:NEvent/Initialize.js",
  dependencies: [],
  module: function() {
    var NEvent = fcf.prepareObject(fcf, "NEvent");

    /**
    * @class fcf::NEvent::Initialize
    *
    *lng_en @brief An event initialization is complete (module: "fcf:NEvent/Initialize.js")
    *lng_ru @brief Событие завершения инициализации (module: "fcf:NEvent/Initialize.js")
    **/
    NEvent.Initialize = function(a_args, a_subEvent) {
      fcf.Event.call(this, "initialize", a_args, a_subEvent);

      /**
      * @var boolean directionalСall
      *lng_en @brief <b>[default true]</b> If true, the event is handled only by the sender
      *lng_ru @brief <b>[default true]</b> Если true, то событие обрабатывается только отправителем
      **/
      this.directionalСall = true;

      /**
      * @var object sender
      *lng_en @brief The object of the event sender
      *lng_ru @brief Объект отправитель события
      **/

      /**
      * @var object error
      *lng_en @brief Error object. If all is well the parameter is not set
      *lng_ru @brief Объект ошибки. Если все хорошо параметр не задан
      **/

      fcf.append(this, a_args);
    }

    return NEvent.Initialize;
  }
});
