fcf.module({
  name: "fcf:NFSQL/NDetails/Automate.js",
  dependencies: ["fcf:NFSQL/NDetails/AutomateSelect.js",
                 "fcf:NFSQL/NDetails/AutomateInsert.js",
                 "fcf:NFSQL/NDetails/AutomateDelete.js",
                 "fcf:NFSQL/NDetails/AutomateUpdate.js",
               ],
  module: function(AutomateSelect, AutomateInsert, AutomateDelete, AutomateUpdate) {
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");

    Automate.State = function(){
      this.step = undefined;


      this.switch = function(a_stepInfo) {
        var name  = a_stepInfo.name;
        if (typeof a_stepInfo.factory === "string") {
          name = a_stepInfo.factory;
          a_stepInfo.factory = Automate[a_stepInfo.factory];
        }

        this.details.stepInfo = a_stepInfo;
        this.buffer = a_stepInfo.attachBuffer ? this.step.buffer : undefined,
        this.step = new a_stepInfo.factory(this,
                                           a_stepInfo.props,
                                           a_stepInfo.attachBuffer ? this.step.buffer : undefined
                                         );
        this.step.actionInit();
      }
    }

    Automate.BaseStep = function(a_state){
      /**
      * values: ""
      *         "^{s}"
      **/
      this.delimeter = "";

      this.state     = a_state;
      this.feed      = undefined;
      this.buffer    = a_state.buffer !== undefined ? a_state.buffer : "";
      this.char      = "";
      this.map       = {};

      this.feed = function(a_char){
        this.char    = a_char;

        if (this.delimeter == "") {
          var nextStepInfo = this.getStep(a_char);
          if (nextStepInfo === undefined){
            throw new fcf.Exception("ERROR_NFSQL_PARSE_UNKNOWN_COMMAND", [a_char]);
          }
          if (nextStepInfo !== null){
            this.actionSwitch();
            this.state.switch(nextStepInfo);
            if (!nextStepInfo.skipFirst)
              this.state.step.feed(a_char);
          } else {
            this.buffer += a_char;
          }
        } else if (this.delimeter == "^{s}") {
          if (this._isSpace(a_char)) {
            var nextStepInfo = this.getStep(this.buffer);
            if (nextStepInfo === undefined){
              throw new fcf.Exception("ERROR_NFSQL_PARSE_UNKNOWN_COMMAND", [this.buffer]);
            }
            if (nextStepInfo === null){
              this.buffer += a_char;
            } else {
              this.actionSwitch();
              this.state.switch(nextStepInfo);
              if (!nextStepInfo.skipFirst)
                this.state.step.feed(a_char);
            }
          } else {
            this.buffer += a_char;
          }
        }

      }

      this.getStep = function(a_text){
        var key = a_text.toLowerCase();
        var nextStepInfo = this.map[key];
        if (nextStepInfo !== undefined)
          return nextStepInfo;

        if (key.length != 1)
          return;

        if (nextStepInfo === undefined && "^{n}" in this.map){
          if (this._isNumberChar(key)){
            nextStepInfo = this.map["^{n}"];
          }
        }

        if (nextStepInfo === undefined && "^{nm}" in this.map){
          if (this._isNamedChar(key)){
            nextStepInfo = this.map["^{nm}"];
          }
        }

        if (nextStepInfo === undefined && "^{nnm}" in this.map){
          if (!this._isNamedChar(key)){
            nextStepInfo = this.map["^{nnm}"];
          }
        }

        if (nextStepInfo === undefined && "^{s}" in this.map){
          if (this._isSpace(key)){
            nextStepInfo = this.map["^{s}"];
          }
        }

        if (nextStepInfo === undefined && "^{ns}" in this.map){
          if (!this._isSpace(key)){
            nextStepInfo = this.map["^{ns}"];
          }
        }

        if (nextStepInfo === undefined && "" in this.map){
          nextStepInfo = this.map[""];
        }

        if (nextStepInfo && nextStepInfo.map) {
          key = this.buffer.toLowerCase();
          if (key in nextStepInfo.map)
            nextStepInfo = nextStepInfo.map[key];
          else if ("" in nextStepInfo.map)
            nextStepInfo = nextStepInfo.map[""];
          else
            nextStepInfo = undefined;
        }

        return nextStepInfo;
      }



      this.actionInit = function(){
      }

      this.actionFeed = function(){
      }

      this.actionSwitch = function(){
      }

      this._isSpace = function(a_char){
        var code = a_char.charCodeAt(0);
        return code <= 32;
      }

      this._isNamedChar = function(a_char){
        var code = a_char.charCodeAt(0);
        if (code >= "a".charCodeAt(0) && code <= "z".charCodeAt(0))
          return true;
        if (code >= "A".charCodeAt(0) && code <= "Z".charCodeAt(0))
          return true;
        if (code >= "0".charCodeAt(0) && code <= "9".charCodeAt(0))
          return true;
        if (a_char === "_")
          return true;
        if (a_char === "@")
          return true;

        return false;
      }

      this._isNumberChar = function(a_char){
        var code = a_char.charCodeAt(0);
        if (code >= "0".charCodeAt(0) && code <= "9".charCodeAt(0))
          return true;
        return false;
      }
    }

    Automate.processField = function(a_state){

    }

    /**
    * @class
    **/
    Automate.StepFirstWhereStart = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = {factory: Automate.StepWhere, name:  "StepWhere", skipFirst: false};
      this.actionSwitch = function() {
          this.state.type = "where";
          this.state.where = [];
          this.state.details.whereStack = [];
          this.state.details.field = {};
      }

    }

    /**
    * @class
    **/
    Automate.StepStart = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{nnm}"] = { map: {
        "select": { factory: Automate.StepSelect_StartSkipSpace, name:  "StepSelect_StartSkipSpace", skipFirst: false},
        "update": { factory: "StepUpdate", skipFirst: false},
        "insert": { factory: Automate.StepInsert_StartSkipSpace, name:  "StepInsert_StartSkipSpace", skipFirst: false},
        "delete": { factory: "StepDelete", skipFirst: false},
      } };

      this.actionSwitch = function() {
        if (this.buffer.toLowerCase() == 'select'){
          this.state.type = "select";
          this.state.from = undefined;
          this.state.fields = [];
          this.state.join = [];
          this.state.where = [];
          this.state.order = [];
          this.state.group = [];
          this.state.limit = undefined;
          this.state.offset = undefined;
          this.state.details.whereStack = [];
          this.state.details.field = {};
        } else if (this.buffer.toLowerCase() == 'update'){
          this.state.type = "update";
          this.state.from = undefined;
          this.state.values = [];
          this.state.where = [];
        } else if (this.buffer.toLowerCase() == 'insert'){
          this.state.type = "insert";
          this.state.from = undefined;
          this.state.values = [];
        } else if (this.buffer.toLowerCase() == 'delete'){
          this.state.type = "delete";
          this.state.from = undefined;
          this.state.where = [];
        }
      }

    }

    /**
    * INSERT
    **/
    // Automate.StepInsert_StartSkipSpace = function(a_state){
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map["^{ns}"] = { factory: Automate.StepInsert_Into, name:  "StepInsert_Into", skipFirst: false};
    // }

    // Automate.StepInsert_Into = function(a_state){
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "^{s}";
    //   this.map["into"] = { factory: Automate.StepInsert_IntoSkipSpace, name:  "StepInsert_IntoSkipSpace", skipFirst: false};
    // }
    //
    // Automate.StepInsert_IntoSkipSpace = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map["\""]    = { factory: Automate.StepInsert_ProjectionDQuoteStart, name:  "StepInsert_ProjectionDQuoteStart", skipFirst: true};
    //   this.map["\'"]    = { factory: Automate.StepInsert_ProjectionQuoteStart,  name:  "StepInsert_ProjectionQuoteStart", skipFirst: true};
    //   this.map["^{ns}"] = { factory: Automate.StepInsert_Projection, name:  "StepInsert_Projection", skipFirst: false};
    // }
    //
    // Automate.StepInsert_Projection = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{ns}"] = null;
    //   this.map["^{s}"] = { factory: Automate.StepInsert_ProjectionQuoteEnd, name:  "StepInsert_ProjectionQuoteEnd", skipFirst: false};
    //   this.map["("] = { factory: Automate.StepInsert_ReadFieldsSkipFields, name:  "StepInsert_ReadFieldsSkipFields", skipFirst: false};
    //   this.actionSwitch = function() {
    //     this.state.insert.projection = this.buffer;
    //   }
    // }
    //
    // Automate.StepInsert_ProjectionQuoteStart = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""] = null;
    //   this.map["'"] = { factory: Automate.StepInsert_ProjectionQuoteEnd, name:  "StepInsert_ProjectionQuoteEnd", skipFirst: true};
    //
    //   this.actionSwitch = function() {
    //     this.state.insert.projection = this.buffer;
    //   }
    // }
    //
    // Automate.StepInsert_ProjectionDQuoteStart = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""] = null;
    //   this.map["\""] = { factory: Automate.StepInsert_ProjectionQuoteEnd, name:  "StepInsert_ProjectionQuoteEnd", skipFirst: true};
    //
    //   this.actionSwitch = function() {
    //     this.state.insert.projection = this.buffer;
    //   }
    // }
    //
    // Automate.StepInsert_ProjectionQuoteEnd = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map["("] = { factory: Automate.StepInsert_ReadFieldsSkipFields, name:  "StepInsert_ReadFieldsSkipFields", skipFirst: true};
    // }
    //
    // Automate.StepInsert_ReadFieldsSkipFields = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"]  = null;
    //   this.map[""]      = { factory: Automate.StepInsert_ReadFields,    name:  "StepInsert_ReadFields", skipFirst: false};
    // }
    //
    // Automate.StepInsert_ReadFields = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["\""] = { factory: Automate.StepInsert_ReadFieldDQuote, name:  "StepInsert_ReadFieldDQuote", skipFirst: true};
    //   this.map["'"]  = { factory: Automate.StepInsert_ReadFieldQuote,  name:  "StepInsert_ReadFieldQuote", skipFirst: true};
    //   this.map[""]   = { factory: Automate.StepInsert_ReadFieldRaw,    name:  "StepInsert_ReadFieldRaw", skipFirst: false};
    // }
    //
    //
    // Automate.StepInsert_ReadFieldDQuote = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""] = null;
    //   this.map["\""] = { factory: Automate.StepInsert_ReadFieldNext, name:  "StepInsert_ReadFieldNext", skipFirst: true};
    //   this.actionSwitch = function() {
    //     this.state.insert._fields.push(this.buffer);
    //     this.state.insert._count = 0;
    //   }
    // }
    //
    // Automate.StepInsert_ReadFieldQuote = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""] = null;
    //   this.map["'"] = { factory: Automate.StepInsert_ReadFieldNext, name:  "StepInsert_ReadFieldNext", skipFirst: true};
    //   this.actionSwitch = function() {
    //     this.state.insert._fields.push(this.buffer);
    //     this.state.insert._count = 0;
    //   }
    // }
    //
    //
    // Automate.StepInsert_ReadFieldRaw = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""] = null;
    //   this.map["^{s}"] = { factory: Automate.StepInsert_ReadFieldNext, name:  "StepInsert_ReadFieldNext", skipFirst: true};
    //   this.map[","] = { factory: Automate.StepInsert_ReadFieldNext, name:  "StepInsert_ReadFieldNext", skipFirst: false};
    //   this.map[")"] = { factory: Automate.StepInsert_ReadFieldNext, name:  "StepInsert_ReadFieldNext", skipFirst: false};
    //   this.actionSwitch = function() {
    //     this.state.insert._fields.push(this.buffer);
    //     this.state.insert._count = 0;
    //   }
    // }
    //
    // Automate.StepInsert_ReadFieldNext = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map[""]   = null;
    //   this.map[")"]  = { factory: Automate.StepInsert_ReadFieldCloseSkipSpace,        name:  "StepInsert_ReadFieldCloseSkipSpace", skipFirst: true};
    //   this.map[","]  = { factory: Automate.StepInsert_ReadFieldsSkipFields,  name:  "StepInsert_ReadFieldsSkipFields", skipFirst: true};
    // }
    //
    // Automate.StepInsert_ReadFieldCloseSkipSpace = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map[""]     = { factory: Automate.StepInsert_ReadFieldClose,       name:  "StepInsert_ReadFieldClose", skipFirst: false};
    // }
    //
    // Automate.StepInsert_ReadFieldClose = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "^{s}";
    //   this.map["values"]  = { factory: Automate.StepInsert_ValuesOpen,       name:  "StepInsert_ValuesOpen", skipFirst: false};
    // }
    //
    // Automate.StepInsert_ValuesOpen = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map["("]  = { factory: Automate.StepInsert_ValuesReadSkipSpaces,  name:  "StepInsert_ValuesReadSkipSpaces", skipFirst: true};
    // }
    //
    // Automate.StepInsert_ValuesReadSkipSpaces = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map["?"]  = { factory: Automate.StepInsert_ValuesReadValue,  name:  "StepInsert_ValuesReadValue", skipFirst: true};
    //   this.actionSwitch = function() {
    //     this.state.insert.values[this.state.insert._fields[this.state.insert._count]] = {
    //       type: "value",
    //       count: this.state.insert._count
    //     };
    //     ++this.state.insert._count;
    //   }
    // }
    //
    // Automate.StepInsert_ValuesReadValue = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map[","]  = { factory: Automate.StepInsert_ValuesReadSkipSpaces,  name:  "StepInsert_ValuesReadSkipSpaces", skipFirst: true};
    //   this.map[")"]  = { factory: Automate.StepInsert_ValuesReadValueEnd,  name:  "StepInsert_ValuesReadValueEnd", skipFirst: true};
    // }
    //
    // Automate.StepInsert_ValuesReadValueEnd = function(a_state) {
    //   Automate.BaseStep.call(this, a_state);
    //   this.delimeter = "";
    //   this.map["^{s}"] = null;
    //   this.map[";"] = null;
    // }


    /**
    * DELETE
    **/
    Automate.StepDelete_Start = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""] = { factory: Automate.StepDelete_From, name:  "StepDelete_From", skipFirst: false};
    }

    Automate.StepDelete_From = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";
      this.map["from"] = { factory: Automate.StepDelete_ReadProjectionSkipSpace, name:  "StepDelete_ReadProjectionSkipSpace", skipFirst: false};
    }

    Automate.StepDelete_ReadProjectionSkipSpace = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""]   = { factory: Automate.StepDelete_ReadProjection, name:  "StepDelete_ReadProjection", skipFirst: false };
      this.map["\""] = { factory: Automate.StepDelete_ReadProjectionDQuotes, name:  "StepDelete_ReadProjectionDQuotes", skipFirst: true};
      this.map["'"] = { factory: Automate.StepDelete_ReadProjectionQuotes, name:  "StepDelete_ReadProjectionQuotes", skipFirst: true};
    }

    Automate.StepDelete_ReadProjectionQuotes = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["'"] = { factory: Automate.StepDelete_PostProjectionSkipSpaces, name:  "StepDelete_PostProjectionSkipSpaces", skipFirst: true};

      this.actionSwitch = function() {
        this.state.delete.projection = this.buffer;
      }
    }

    Automate.StepDelete_ReadProjectionDQuotes = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["\""] = { factory: Automate.StepDelete_PostProjectionSkipSpaces, name:  "StepDelete_PostProjectionSkipSpaces", skipFirst: true};

      this.actionSwitch = function() {
        this.state.delete.projection = this.buffer;
      }
    }


    Automate.StepDelete_ReadProjection = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""] = null;
      this.map["^{s}"] = { factory: Automate.StepDelete_PostProjectionSkipSpaces, name:  "StepDelete_PostProjectionSkipSpaces", skipFirst: false};

      this.actionSwitch = function() {
        this.state.delete.projection = this.buffer;
      }
    }

    Automate.StepDelete_PostProjectionSkipSpaces = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map[""] = { factory: Automate.StepDelete_Where, name:  "StepDelete_Where", skipFirst: false};
    }

    Automate.StepDelete_Where = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";
      this.map["where"] = { factory: Automate.StepSelect_Where_Prepare, name:  "StepSelect_Where_Prepare", skipFirst: false};
    }
    /**
    * UPDATE
    **/
    Automate.StepUpdate_StartSkipSpace = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{ns}"] = { factory: Automate.StepUpdate_ReadProjection, name:  "StepUpdate_ReadProjection", skipFirst: false};
    }


    Automate.StepUpdate_ReadProjection = function(a_state){
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{s}"] = { factory: Automate.StepUpdate_ReadProjection_SkeepSpace, name:  "StepUpdate_ReadProjection_SkeepSpace", skipFirst: true};

      this.actionSwitch = function() {
        this.state.curUpdateData.projection = this.buffer;
      }
    }

    Automate.StepUpdate_ReadProjection_SkeepSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";
      this.map["set"] = { factory: Automate.StepUpdate_Field_Part1_SkipSpace, name:  "StepUpdate_Field_Part1_SkipSpace", skipFirst: false};;
    }

    Automate.StepUpdate_Field_Part1_SkipSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: Automate.StepUpdate_Field_Part1_Read, name:  "StepUpdate_Field_Part1_Read", skipFirst: false};;
    }

    Automate.StepUpdate_Field_Part1_Read = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = {
        map: {
          "":      { factory: Automate.StepUpdate_Field_Equal_SkeepSpace, name:  "StepUpdate_Field_Equal_SkeepSpace", skipFirst: false},
          "where": { factory: Automate.StepSelect_Where_Prepare, name:  "StepSelect_Where_Prepare", skipFirst: false}
        }
      };

      this.map["^{nm}"] = null;

      this.actionSwitch = function() {
        if (this.buffer.toLowerCase() != 'where')
          this.state.curUpdateData.values.push({
                    field: {
                      parts: [this.buffer],
                      type: "field",
                      args: [],
                      }
                    });
      }
    }

    Automate.StepUpdate_Field_Equal_SkeepSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["="] = { factory: Automate.StepUpdate_Field_ReadValue_SkeepSpace, name:  "StepUpdate_Field_ReadValue_SkeepSpace", skipFirst: true};
    }

    Automate.StepUpdate_Field_ReadValue_SkeepSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["$"] = { factory: Automate.StepUpdate_Field_ReadValue_Part1, name:  "StepUpdate_Field_ReadValue_Part1", skipFirst: true};
    }

    Automate.StepUpdate_Field_ReadValue_Part1 = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["{"] = { factory: Automate.StepUpdate_Field_ReadValue_Number_SkeepSpace, name:  "StepUpdate_Field_ReadValue_Number_SkeepSpace", skipFirst: true};
    }

    Automate.StepUpdate_Field_ReadValue_Number_SkeepSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: Automate.StepUpdate_Field_ReadValue_Number, name:  "StepUpdate_Field_ReadValue_Number", skipFirst: false};
    }

    Automate.StepUpdate_Field_ReadValue_Number = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"] = null;
      this.map["^{s}"] = { factory: Automate.StepUpdate_Field_ReadValue_Number_PostSkeepSpace, name:  "StepUpdate_Field_ReadValue_Number_PostSkeepSpace", skipFirst: false};
      this.map["}"] = { factory: Automate.StepUpdate_Field_ReadValue_Number_Close, name:  "StepUpdate_Field_ReadValue_Number_Close", skipFirst: true};

      this.actionSwitch = function() {
        this.state.curUpdateData.values[this.state.curUpdateData.values.length-1].value = { type: 'value', count: parseInt(this.buffer)-1};
      }
    }

    Automate.StepUpdate_Field_ReadValue_Number_PostSkeepSpace = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["}"] = { factory: Automate.StepUpdate_Field_ReadValue_Number_Close, name:  "StepUpdate_Field_ReadValue_Number_Close", skipFirst: true};
    }

    Automate.StepUpdate_Field_ReadValue_Number_Close = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: Automate.StepUpdate_Field_Part1_SkipSpace, name:  "StepUpdate_Field_Part1_SkipSpace", skipFirst: false};
      this.map[","] = { factory: Automate.StepUpdate_Field_Part1_SkipSpace, name:  "StepUpdate_Field_Part1_SkipSpace", skipFirst: true};
    }



    return Automate;
  }
});
