fcf.module({
  name: "fcf:NFSQL/NFilter/Password.js",
  dependencies: ["fcf:NFSQL/NFilter/BaseSimpleType.js","fcf:NAuthorization/authorizationHandler.js"],
  module: function(BaseSimpleType, authorizationHandler){
    var Namespace = fcf.prepareObject(fcf, "packages/fcf/NFSQL/NFilter");

    class Password extends BaseSimpleType{
      constructor(){
        super({type: "password"}) ;
        this.comparisons = {
          "*": ["="],
        };
      }

      getRealFields(a_projection, a_fieldAlias){
        var selfField = a_projection.fieldsMap[a_fieldAlias];
        var refField = a_projection.fieldsMap[selfField.refField];
        var result = fcf.append(true, {}, selfField);
        result.type = "string";
        return [result];
      }


      validate(a_description, a_dstErrors) {
        var value = fcf.str(a_description.data);
        if ((a_description.field.notEmpty || a_description.field.notNull) && fcf.empty(value) ) {
          a_dstErrors.push(new fcf.Exception("ERROR_FIELD_VALIDATION_NOT_EMPTY"));
          return;
        }

        let byteCount = fcf.byteCount(value);
        if (!fcf.empty(a_description.field.maxSize)) {
          byteCount = fcf.byteCount(value);
          if (byteCount > a_description.field.maxSize) {
            a_dstErrors.push(new fcf.Exception("ERROR_FIELD_VALIDATION_MAX_BYTE_COUNT", {count: byteCount, maxcount: a_description.field.maxSize}));
            return;
          }
        }

        if (byteCount > 255) {
          a_dstErrors.push(new fcf.Exception("ERROR_FIELD_VALIDATION_MAX_BYTE_COUNT", {count: byteCount, maxcount: a_description.field.maxSize}));
          return;
        }
      }

      postProcessOutputField(a_taskInfo, a_info) {
        fcf.each(a_taskInfo.result, (k, record)=>{
          record[a_info.field.as] = record[a_info.field.as] !== null && record[a_info.field.as] !== undefined && record[a_info.field.as] != "";
        });
      }

      processUpdateField(a_taskInfo, a_info){
        super.processUpdateField(a_taskInfo, a_info);
        a_info.field.value = a_info.field.value === undefined || a_info.field.value === null || a_info.field.value === "" 
                                ? null
                                : authorizationHandler.getDBPassword(a_info.field.value);
      }

      processInsertField(a_taskInfo, a_info){
        super.processInsertField(a_taskInfo, a_info);
        a_info.field.value = a_info.field.value === undefined || a_info.field.value === null || a_info.field.value === "" 
                                ? null
                                : authorizationHandler.getDBPassword(a_info.field.value);
      }



    };

    Namespace.Password = Password;

    return Namespace.Password;
  }
});
