fcf.module({
  name: "fcf:NRender/NDetails/Helper.js",
  module: function() {



    function setArg(a_taskInfo, a_argName, a_value){
        var normPath = fcf.normalizeObjectAddress(a_argName);
        var ptr = fcf.resolveEx(a_taskInfo.args, normPath, true);
        ptr.object[ptr.key] = a_value;
        delete a_taskInfo.srcArgs[normPath];
        a_taskInfo.processedArgs[normPath] = true;
    }

    return {
      appendChildInfo: function(a_dstArgs, a_srcArgs, a_chlidInfo){
        if (!a_chlidInfo || !a_chlidInfo.childs)
          return;
        if (!a_srcArgs)
          return;
        if (a_chlidInfo.childs[a_srcArgs.fcfCP]) {
          fcf.append(a_dstArgs, a_chlidInfo.childs[a_srcArgs.fcfCP].args);
          a_dstArgs.fcfChildsArgs = a_chlidInfo.childs[a_srcArgs.fcfCP];
        }
      },

      callHook: function(a_template, a_name, a_taskInfo) {
        if (!a_template.hooks || !a_template.hooks[a_name])
          return;
        fcf.setContext(a_taskInfo.context);
        if (typeof a_template.hooks[a_name] == "function"){
          var result = a_template.hooks[a_name].call(a_template.hooks, a_taskInfo);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          }
        }
      },
      callHookBeforeArgument: function(a_template, a_argName, a_taskInfo) {
        if (!a_template.hooks || !a_template.hooks.hooksBeforeArgument || !a_template.hooks.hooksBeforeArgument[a_argName])
          return;
        fcf.setContext(a_taskInfo.context);
        if (typeof a_template.hooks.hooksBeforeArgument[a_argName] == "function") {
          var result = a_template.hooks.hooksBeforeArgument[a_argName].call(a_template.hooks, a_taskInfo, a_argName);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          }
        }
        if (typeof a_template.hooks.hooksBeforeArgument["*"] == "function") {
          var result = a_template.hooks.hooksBeforeArgument["*"].call(a_template.hooks, a_taskInfo, a_argName);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          }
        }
      },
      callHookAfterArgument: function(a_template, a_argName, a_taskInfo) {
        if (!a_template.hooks || !a_template.hooks.hooksAfterArgument || !a_template.hooks.hooksAfterArgument[a_argName])
          return;
        fcf.setContext(a_taskInfo.context);
        if (typeof a_template.hooks.hooksAfterArgument[a_argName] == "function") {
          var result = a_template.hooks.hooksAfterArgument[a_argName].call(a_template.hooks, a_taskInfo, a_argName);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          } else if (result !== undefined) {
            setArg(a_taskInfo, a_argName, result);
          }
        }
        if (typeof a_template.hooks.hooksAfterArgument["*"] == "function") {
          var result = a_template.hooks.hooksAfterArgument["*"].call(a_template.hooks, a_taskInfo, a_argName);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          } else if (result !== undefined) {
            setArg(a_taskInfo, a_argName, result);
          }
        }
      },
      callHookProgramableArgument: function(a_template, a_argName, a_taskInfo) {
        if (!a_template.hooks || !a_template.hooks.hooksProgramableArgument || !a_template.hooks.hooksProgramableArgument[a_argName])
          return;
        fcf.setContext(a_taskInfo.context);
        if (typeof a_template.hooks.hooksProgramableArgument[a_argName] == "function"){
          var result = a_template.hooks.hooksProgramableArgument[a_argName].call(a_template.hooks, a_taskInfo);
          if ((typeof Promise !== "undefined" && result instanceof Promise) || result instanceof fcf.Actions) {
            a_taskInfo.actions.then(function(a_res, a_act){
              result
              .then(function(result){
                setArg(a_taskInfo, a_argName, result);
                a_act.complete();
              })
              .catch(function(a_error){
                a_act.error(a_error);
              });
            });
          } else if (result !== undefined) {
            setArg(a_taskInfo, a_argName, result);
          }
        }
      }
    };
  }
});
