fcf.module({
  name: "fcf:NServer/NControllers/Route.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller){
    var Namespace = fcf.prepareObject(fcf, "packages/fcf/NServer/NControllers");

    class Route  extends Controller{
      constructor(a_options){
        super(a_options);
        this.userImportance = true;
      }

      action(a_request) {
        if (!a_request.getRouteData().args.url){
          a_request.sendError(new fcf.Exception("ERROR_HTTP_ARG_NOT_SET", {"arg": "url"}));
          return;
        }

        var routeInfo = new fcf.RouteInfo({url: a_request.getRouteData().args.url});
        fcf.application.getRouter().getNode(a_request.getRouteData().args.url)
        .then((a_node)=>{
          if (!a_node)
            throw new fcf.Exception("ERROR_404", {"address": routeInfo.url});
          fcf.append(routeInfo.args, a_node.args);
          routeInfo.subUri = a_node.subUri;
          routeInfo.title  = a_node.node.title;
          a_request.send({route: routeInfo});
        })
        .catch((a_error)=>{
          a_request.sendError(a_error);
        })
      }
    };

    Namespace.Route = Route;

    return Namespace.Route;
  }
});
