/**
* @namespace fcf::NServer
*lng_en @brief The namespace of the server part of the framework
*lng_ru @brief Пространство имен серверной части фреймворка
**/


var   fcf = require("../fcf");

fcf.module({
  name: "fcf:NServer/NServer.js",
  dependencies: [],
  module: function(Router, Request) {
    fcf.prepareObject(fcf, "NServer");

    fcf.NServer._controllers = {};

    fcf.NServer.registryController = function(a_name, a_factory) {
      fcf.NServer._controllers[a_name] = {factory: a_factory};
    }

    fcf.NServer.createController = function(a_name, a_application, a_request, a_options){
      return new fcf.NServer._controllers[a_name].factory(a_application, a_request, a_options);
    }

    return fcf.NServer;
  }
});
