var libBabel = require("@babel/core");

fcf.module({
  name: "fcf:NTools/babel.js",
  dependencies: [],
  module: function(){
    var Namespace = fcf.prepareObject(fcf, "packages/fcf/NTools");

    class Babel {
      constructor(){
      }

      isNeedCompile(a_userAgentString){
        function getBrowser(a_userAgentString){
          let checkstr = undefined;
          let checkstr2 = undefined;
          let pos = undefined;
          let pos2 = undefined;

          checkstr = "Firefox/";
          checkstr2 = "Mobile";
          pos = a_userAgentString.indexOf(checkstr);
          pos2 = a_userAgentString.indexOf(checkstr2);
          if (pos != -1 && pos2 != -1){
            pos += checkstr.length;
            pos2 += checkstr2.length;
            return {
              browser: "firefox-mobile",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }

          checkstr = "Chrome/";
          checkstr2 = " Mobile ";
          pos = a_userAgentString.indexOf(checkstr);
          pos2 = a_userAgentString.indexOf(checkstr2);
          if (pos != -1 && pos2 != -1){
            pos += checkstr.length;
            pos2 += checkstr2.length;
            return {
              browser: "chrome-mobile",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }


          checkstr = "Safari/";
          checkstr2 = "Version/";
          pos = a_userAgentString.indexOf(checkstr);
          pos2 = a_userAgentString.indexOf(checkstr2);
          if (pos != -1 && pos2 != -1){
            pos += checkstr.length;
            pos2 += checkstr2.length;
            return {
              browser: "safari",
              version: a_userAgentString.substring(pos2, a_userAgentString.indexOf(".", pos2))
            }
          }

          checkstr = "Edg/";
          pos = a_userAgentString.indexOf(checkstr);
          if (pos != -1){
            pos += checkstr.length;
            return {
              browser: "edge",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }
          
          checkstr = "OPR/";
          pos = a_userAgentString.indexOf(checkstr);
          if (pos != -1){
            pos += checkstr.length;
            return {
              browser: "opera",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }

          checkstr = "Firefox/";
          pos = a_userAgentString.indexOf(checkstr);
          if (pos != -1){
            pos += checkstr.length;
            return {
              browser: "firefox",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }

          checkstr = "Chrome/";
          pos = a_userAgentString.indexOf(checkstr);
          if (pos != -1){
            pos += checkstr.length;
            return {
              browser: "chrome",
              version: a_userAgentString.substring(pos, a_userAgentString.indexOf(".", pos))
            }
          }

          return {
              browser: undefined,
              version: undefined
            }
        }

        let browser = getBrowser(a_userAgentString);
        if (!browser.browser || !browser.version)
          return true;

        if (browser.browser == "chrome" && parseInt(browser.version) >= 58)
          return false;
        if (browser.browser == "chrome-mobile" && parseInt(browser.version) >= 58)
          return false;
        if (browser.browser == "firefox" && parseInt(browser.version) >= 52)
          return false;
        if (browser.browser == "firefox-mobile" && parseInt(browser.version) >= 52)
          return false;
        if (browser.browser == "edge" && parseInt(browser.version) >= 13)
          return false;
        if (browser.browser == "opera" && parseInt(browser.version) >= 45)
          return false;
        if (browser.browser == "safari" && parseInt(browser.version) >= 10)
          return false;

        return true;
      }

      getCompileFilePath(a_path){

      }

      prepareFile(a_path){
        return fcf.actions()
      }

      transform(a_code){
        return fcf.actions()
        .then((a_res, a_act)=>{
          libBabel.transform(
            a_code, 
            { 
              code: true,
              sourceType: "script",
              root: fcf.getPath("fcf:"),
              cwd: fcf.getPath("fcf:"),
              "plugins": ["@babel/plugin-transform-parameters",
                          "@babel/plugin-transform-classes",
                          "@babel/plugin-transform-arrow-functions",
                          "@babel/plugin-transform-template-literals",
                          "@babel/plugin-transform-sticky-regex",
                          "@babel/plugin-transform-object-super",
                          "@babel/plugin-transform-literals",
                          "@babel/plugin-transform-function-name",
                          "@babel/plugin-transform-for-of",
                          "@babel/plugin-transform-computed-properties",
                          "@babel/plugin-transform-block-scoping",
                          "@babel/plugin-transform-property-mutators",
                          "@babel/plugin-transform-member-expression-literals",
                          "@babel/plugin-transform-async-to-generator",
                          "@babel/plugin-transform-regenerator",
                          ],
            }, 
            (a_error, a_result)=>{
              if (a_error){
                a_act.error(a_error);
                return
              }
              a_act.complete(a_result.code);
            }
          );
        })
      }

    };

    Namespace.babel = new Babel();

    return Namespace.babel;
  }
});
