fcf.module({
  name: "fcfControls:templates/float-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class FloatWrapper extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._lastValue = this.getArg("value");
      }

      onArg(a_name, a_value, a_editor, a_isInnerCall, a_suffix){
        if (a_editor != this)
          this.update();
      }

      getActionDomElement(){
        return fcf.first(fcf.select(this.getDomElement(), "input"));
      }

      onInput(a_event) {
        var dotCount = 0;
        var charCode0 = "0".charCodeAt(0);
        var charCode9 = "9".charCodeAt(0);
        var incorrect = false;
        fcf.each(this.getActionDomElement().value, function(a_key, a_char){
          var cc = a_char.charCodeAt()
          if (a_char == ".")
            ++dotCount;
          if ( (cc >= charCode0 && cc <= charCode9) ||
               (a_key == 0 && a_char == "-") ||
               (dotCount == 1 && a_char == ".")
              ) {
            return;
          } else {
            incorrect = true;
            return false;
          }
        });

        if (!incorrect)
          this._lastValue = this.getActionDomElement().value;

        this.setArg("value", this._lastValue);

        if (incorrect)
          this.getActionDomElement().value = this._lastValue;
      }

    };
  }
});
