fcf.module({
  name: "fcfControls:templates/int-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._lastValue = this.getArg("value");
      }

      onArg(a_name, a_value, a_editor, a_isInnerCall, a_suffix){
        if (a_editor != this)
          this.update();
      }

      getActionDomElement(){
        return fcf.select(this.getDomElement(), "input")[0];
      }

      onInput(a_event) {
        var charCode0 = "0".charCodeAt(0);
        var charCode9 = "9".charCodeAt(0);
        var incorrect = false;
        fcf.each(this.getActionDomElement().value, function(a_key, a_char){
          var cc = a_char.charCodeAt()
          if ((cc < charCode0 || cc > charCode9) && (a_key != 0 || a_char != "-")){
            incorrect = true;
            return true;
          }
        });

        if (!incorrect)
          this._lastValue = this.getActionDomElement().value;

        this.setArg("value", this._lastValue);

        if (incorrect)
          this.getActionDomElement().value = fcf.str(this._lastValue);
      }

    };
  }
});
