fcf.module({
  name: "fcfControls:templates/locker.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      initialize() {
        return super.initialize()
        .then(()=>{
          this._resize();
          var lockSelector = this.getArg("lockSelector");
          var ownerElement = fcf.first(fcf.select(lockSelector));
          var selfElement  = this.getDomElement();

          var rect = fcf.getClientRect(ownerElement);

          selfElement.parentElement.removeChild(selfElement);
          ownerElement.appendChild(selfElement);
          selfElement.classList.remove("fcflocker-init");
          selfElement.classList.add("fcflocker");
          selfElement.classList.add("fcflocker-show");

          selfElement.style.height = (rect.height+10) + "px"
          selfElement.style.marginTop = "-" + (rect.height-5) + "px"
        })
      }

      destroy(){
        let self = this;
        let selfElement  = this.getDomElement();
        selfElement.classList.remove("fcflocker-show");
        selfElement.classList.add("fcflocker-hide");
        setTimeout(function(){
          Wrapper.prototype.destroy.call(self);
        },500);
      }

      _resize() {
        var lockSelector = this.getArg("lockSelector");
        var element = fcf.first(fcf.select(lockSelector));
      }



    };
  }
});
