fcf.module({
  name: "fcfControls:templates/password.wrapper.js",
  dependencies: ["fcfControls:templates/text-edit.wrapper.js"],
  module: function(BaseWrapper){
    return class PasswordWrapperEx extends BaseWrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._ignoreArgEvents = false;
      }

      onArg (a_argName, a_value) {
        if (!this._ignoreArgEvents)
          this.update();
      }

      onInput(a_event){
        this._ignoreArgEvents = true;
        if (typeof this.getArg("value") === "boolean") {
          a_event.target.value = a_event.data;
          this.setArg("value", a_event.data);
        } else {
          this.setArg("value", a_event.target.value);
        }
        this._ignoreArgEvents = false;
      }

    };
  }
});
