fcf.module({
  name: "fcfControls:templates/tabs.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      // hooksProgramableArgument: {
      //   //
      //   // @result Returns the value of an argument or a Promise object
      //   //
      //   "ARG_NAME": function(a_taskInfo){
      //   }
      // },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   // 
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      hooksAfterArgument: {
        //
        // @result Can return the value of an argument or Promise or undefined
        //
        'reload': (a_taskInfo) =>{
          if (!a_taskInfo.args.reload)
            return;
          var items = fcf.isArg(a_taskInfo.srcArgs.items) ? a_taskInfo.srcArgs.items.value : a_taskInfo.srcArgs.items;

          fcf.each(items, function(a_key, a_item){
            var needCompress = false;
            try {
              let val = JSON.parse(fcf.lz.decompressFromBase64(items[a_key].data));
              if (val === null)
                needCompress = true;
            } catch (e){
              needCompress = true;
            }
            if (items[a_key].data)
              items[a_key].data = fcf.lz.compressToBase64(JSON.stringify(items[a_key].data));
          });
        }
      },
    };
  }
});
