fcf.module({
  name: "fcfControls:templates/tabs.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class TabWrapper extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onClick(a_event){
        this.setArg("tab", a_event.target.getAttribute("key"))
      }

      onArgTab(a_tab){
        let activeContainer = undefined;
        let activeName = undefined;
        let lastWrapper = undefined;
        let elemenets = fcf.select(this.getDomElement().parentElement,  "[id=" + this.getId() + "]>div>[content]");
        fcf.each(elemenets, function(a_key, a_element){
          var key = a_element.getAttribute("key");
          if (a_tab == key){
            a_element.style.display = "block";
            activeContainer = a_element;
            activeName      = key;
          } else {
            if (a_element.style.display !== "none" && !fcf.empty(a_element.firstElementChild)){
              lastWrapper = fcf.getWrapper(a_element.firstElementChild.getAttribute("id"));
            }
            a_element.style.display = "none";
          }
        });
        elemenets = fcf.select(this.getDomElement().parentElement,  "[id=" + this.getId() + "]>div>div>[tab]");
        fcf.each(elemenets, function(a_key, a_element){
          var key = a_element.getAttribute("key");
          if (a_tab == key){
            a_element.classList.add("active");
          } else {
            a_element.classList.remove("active");
          }
        });

        if (this.getArg("reload")) {
          if (lastWrapper)
            lastWrapper.destroy();
          let sources = fcf.application.getLocalData().getSourceItem(this._id, "items");
          sources = fcf.isArg(sources) ? sources.value : sources;
          var activeSource = sources[activeName]
          var dataSource = JSON.parse(fcf.lz.decompressFromBase64(activeSource.data));
          if (fcf.isArg(dataSource) && dataSource.type == "template"){
            activeContainer.innerHTML = "";
            dataSource.owner = activeContainer;
            if (!dataSource.args)
              dataSource.args = {};
            dataSource.args.fcfParent = this.getId();
            fcf.application.render(dataSource);
          } else if (fcf.isArg(dataSource) && dataSource.type == "value"){
            activeContainer.innerHTML = dataSource.value;
          } else {
            activeContainer.innerHTML = dataSource;
          }
        }
      }
    };
  }
});
