fcf.module({
  name: "fcfControls:templates/textarea.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArg(a_argName, a_value, a_editor) {
        if (a_editor != this)
          this.update();
      }

      getActionDomElement() {
        return fcf.select(this.getDomElement(), "textarea")[0];
      }

      onInput(a_event){
        this.setArg("value", this.getActionDomElement().value);
      }
      onKeyPress(a_event){
        if (a_event.key == "Enter"){
          let element = this.getActionDomElement();
          let value = element.value;
          let end = element.selectionEnd;
          let pos = element.selectionStart;
          let ns = 0;
          for(let i = pos-1; i >= 0; --i){
            let char = value[i];
            let charcode = value.charCodeAt(i);
            if (char == "\r" || char == "\n")
              break;
            if (charcode>32)
              ns = 0;
            else
              ++ns;
          }
          a_event.preventDefault();
          a_event.stopPropagation();

          let fill = "\n";
          for(let i = 0; i < ns; ++i)
            fill += " ";
          let content = value.substring(0, pos) + fill + value.substring(end);
          this.getActionDomElement().value = content;
          element.selectionEnd = end + fill.length;
          element.selectionStart = pos + fill.length;
          this.onInput();
        }
      }

    };
  }
});
