fcf.module({
  name: "fcfControls:templates/view.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class BaseControlWrapper extends Wrapper {
      constructor(a_initializeOptions){
        super(a_initializeOptions)
      }

      initialize() {
        let type = this.getArg("type");
        if (type) {
          return fcf.loadFilters([type])
                  .then(()=>{
                    return super.initialize();
                  });
        }
        return super.initialize();
      }

      validate(a_value, a_info, a_errors) {
        let self  = this;
        let args  = this.getArgs();
        let value = this.getArg("value");
        if (!args.type)
          return;
        let filter = fcf.getFilter(args);
        if (!filter)
          return;

        let errors = [];
        filter.validate({data: value, field: args}, errors);
        fcf.each(errors, (a_key, a_error)=>{
          if (a_info.secondPriority && a_error.name == "ERROR_FIELD_VALIDATION_NOT_EMPTY")
            return;
          a_errors.push({
            id:    self.getId(),
            alias: self.getAlias(),
            error: a_error
          });
        });
      }
      
    };
  }
});
