fcf.module({
  name: "fcfManagement:templates/pages/data/records/records+body.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onView(a_id){
        let record = fcf.findVal(this.getChild("table").getArg("value"), (a_key, a_record)=>{ return a_record["@key"] == a_id });
        fcf.application.render({
          template: "@controls:dialog",
          parent: this,
          owner:  document.body,
          args: {
            fcfStyle: "width: 100%; min-width: 300px; max-width: 90%",
            title: fcf.t("View record") + " '" + record["@title"] + "'",
            content: fcf.argTmpl("@dbcontrols:form", 
                                {
                                  fcfAlias:   "form",
                                  mode:       "read",
                                  projection: fcf.getContext().route.args.projection,
                                  key:        a_id,
                                }),
          }
        });
      }    

      onEdit(a_id){
        let record = fcf.findVal(this.getChild("table").getArg("value"), (a_key, a_record)=>{ return a_record["@key"] == a_id });
        fcf.application.render({
          template: "@controls:dialog",
          parent: this,
          owner:  document.body,
          args: {
            fcfStyle: "width: 100%; min-width: 300px; max-width: 90%",
            title: fcf.t("Editing an entry") + " '" + record["@title"] + "'",
            content: fcf.argTmpl(
                        "@dbcontrols:form", 
                        { 
                          fcfAlias:   "form",
                          mode:       "edit",
                          projection: fcf.getContext().route.args.projection,
                          key:        a_id,
                        }),
            buttons: fcf.argVal([
              fcf.argTmpl("@controls:button", {title: fcf.t("Ok"), fcfEventClick: "parent.getParent().onEditComplete(parent)"}),
              fcf.argTmpl("@controls:button", {title: fcf.t("Cancel"), fcfEventClick: "parent.close('cancel')" }),
            ]),
          }
        });
      }

      onEditComplete(a_dialog) {
        let self = this;
        let errors = a_dialog.getChild("form").check();
        if (!fcf.empty(errors)){
          a_dialog.getChild("form").setArg("errors", errors);
          return;
        }
        a_dialog.getChild("form").write()
        .then(()=>{
          self.getChild("table").update();
          a_dialog.close("ok");
        })
        .catch((a_error)=>{
          fcf.application.getEventChannel().send("error", {error: a_error});
        })
      }

      onNewRecord(){
        fcf.application.render({
          template: "@controls:dialog",
          parent:   this,
          owner:    document.body,
          args: {
            fcfStyle: "width: 100%; min-width: 300px; max-width: 90%",
            title: fcf.t("Create new record"),
            content: fcf.argTmpl("@dbcontrols:form", 
                                { 
                                  fcfAlias:   "form",
                                  mode:       "add",
                                  projection: fcf.getContext().route.args.projection,
                                }),
            buttons: fcf.argVal([
              fcf.argTmpl("@controls:button", {title: fcf.t("Ok"), fcfEventClick: "parent.getParent().onNewRecordComplete(parent)" }),
              fcf.argTmpl("@controls:button", {title: fcf.t("Cancel"), fcfEventClick: "parent.close('cancel')" }),
            ])
          },
        });
      }

      onNewRecordComplete(a_dialog){
        let errors = a_dialog.getChild("form").check();
        if (!fcf.empty(errors)){
          a_dialog.getChild("form").setArg("errors", errors);
          return;
        }
        let self = this;
        a_dialog.getChild("form").write(true)
        .then(()=>{
          self.getChild("table").update();
          a_dialog.close("ok");
        })
        .catch((a_error)=>{
          fcf.application.getEventChannel().send("error", {error: a_error});
        })
      }

      onDelete(a_id){
        let record = fcf.findVal(this.getChild("table").getArg("value"), (a_key, a_record)=>{ return a_record["@key"] == a_id });
        fcf.application.render({
          template: "@controls:dialog",
          parent:   this,
          owner:    document.body,
          args: {
            title: fcf.t("Record deletion") + " '" + record["@title"] + "'",
            content: fcf.argTmpl("@dbcontrols:removal-form", 
                                { 
                                  fcfAlias:    "form",
                                  key:         a_id,
                                  projection:  fcf.getContext().route.args.projection,
                                }),
            buttons: fcf.argVal([
              fcf.argTmpl("@controls:button", {title: fcf.t("Ok"), fcfEventClick: "parent.getParent().onDeleteComplete(parent)" }),
              fcf.argTmpl("@controls:button", {title: fcf.t("Cancel"), fcfEventClick: "parent.close('cancel')" }),
            ])
          }
        });
      }

      onDeleteComplete(a_dialog) {
        let self = this;
        a_dialog.getChild("form").delete()
        .then(()=>{
          self.getChild("table").update();
          a_dialog.close("ok");
        })
        .catch((a_error)=>{
          fcf.application.getEventChannel().send("error", {error: a_error});
        })
      }

      onArg(a_argName, a_value, a_editor, a_isInnerCall, a_suffix) {
        this.update();
      }

    };
  }
});
