fcf.module({
  name: "fcfManagement:templates/pages/translations/settings-tab.receive.js",
  dependencies: [],
  module: function(){
    var self = this;
    return {
      receive: function(a_fields, a_files){
        let lastLanguage = fcf.getSystemVariable("fcf", "defaultLanguage");

        return fcf.actions()
        .then(()=>{
          fcf.setSystemVariable("fcf:languages", a_fields.languages);
        })
        .then(()=>{
          let li = fcf.getSystemVariable("fcf:languageIdentification");
          li.byPrefix = a_fields.byPrefix;
          li.byCookie = a_fields.byCookie;
          li.byParameter = a_fields.byParameter;
          li.parameter = a_fields.parameter;
          li.byHTTP = a_fields.byHTTP;
          return fcf.setSystemVariable("fcf:languageIdentification", li);
        })
        .then(()=>{
          return fcf.setSystemVariable("fcf:defaultLanguage", a_fields.defaultLanguage);
        })
        .then(()=>{
          return fcf.application.getEventChannel().send("translations");
        })
        .then(function(){
          return fcf.application.getEventChannel().send("restart")
            .then(()=>{});
        })
        .catch((a_error)=>{
          fcf.log.err("FCF:MANAGER", "Failed to set default language: ", a_error);
        });        
      }
    }
  }
});
