var fcf = require("./fcf");
require('events').EventEmitter.prototype._maxListeners = 0;
require('events').EventEmitter.defaultMaxListeners = 0

fcf.module({
  name: "test.js",
  dependencies: [
                "fcf:NServer/Application.js",
                "fcf:NTest/uniTest.js",
                "fcf:tests/getVariablesString.test.js",

                "fcf:tests/NFSQL/Parser.select.test.js",
                "fcf:tests/NFSQL/Parser.select.queryjoin.test.js",
                "fcf:tests/NFSQL/Parser.insert.test.js",
                "fcf:tests/NFSQL/Parser.delete.test.js",
                "fcf:tests/NFSQL/Parser.update.test.js",
                "fcf:tests/NFSQL/Parser.updateJoin.js",
                "fcf:tests/NFSQL/Builder.test.js",
                "fcf:tests/NFSQL/Parser.multiquery.test.js",
                // // "fcf:NFSQL/NTests/NDB/NFields/singleRef.js",
                // // "fcf:NFSQL/NTests/NDB/NFields/externRef.js",
                // "fcf:tests/NRender/block.test.js",
                "fcf:tests/tokenize.test.js",
                "fcf:tests/NFSQL/DB.Select.test.js",
                "fcf:tests/NFSQL/DB.SelectSysJoin.js",
                "fcf:tests/NFSQL/DB.SelectFunctions.js",
                "fcf:tests/NFSQL/DB.Update.js",
                "fcf:tests/NFSQL/DB.UpdateJoin.js",
                "fcf:tests/NFSQL/DB.InsertAndDelete.js",
                "fcf:tests/NFSQL/DB.InsertJoin.js",
                "fcf:tests/NFSQL/DB.DeleteJoin.js",
                "fcf:tests/NFSQL/DB.FieldFile.js",
                "fcf:tests/NFSQL/DB.FieldFileJoin.js",
                "fcf:tests/NFSQL/DB.FieldFileRefJoin.js",
                "fcf:tests/NFSQL/DB.FieldExternalRef.js",
                "fcf:tests/NFSQL/DB.FieldExternalRefJoin.js",
                "fcf:tests/NFSQL/DB.Field.SingleRef.js",
                "fcf:tests/NFSQL/DB.Field.SingleRefJoin.js",
                "fcf:tests/NFSQL/DB.Field.BackRef.js",

                // "fcf:tests/NServer/Cron.js",



                //"fcf:tests/memoryConnection.js",
              ],
  module: async function(application, uniTest) {

    application.getConfiguration().appendOverwriteConfiguration({
      dataClient: {
        defaultConnection: "default",
        connections: {
          default: {
            type: "mysql",
            host: "localhost",
            db:   "fcf-tests",
            user: "root",
            pass: "root",
          }
        },
      },
    });
    application.initialize()
    .then((a_res, a_act)=>{

      fcf.application.getThemes().setAliases({"path:files": "fcf:files/files"})

      let argstate = "";
      let groups = [];
      let tests = [];
      fcf.each(process.argv, (k,v) => {
        if (v == "--groups")
          argstate = "groups";
        else if (v == "--tests")
          argstate = "tests";
        else if (argstate == "groups")
          groups.push(v);
        else if (argstate == "tests")
          tests.push(v);
      });

      uniTest.run(groups, tests, function(){
        a_act.complete();
      });
    })
    .then(function(){
      process.exit(0);
    })
  }
});
