fcf.module({
  name: "fcf:tests/NFSQL/Builder.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js", "fcf:NFSQL/NDetails/SingleBuilder.js"],
  module: function(uniTest, Parser, Builder) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();
    var builder = new Builder();

    uniTest.add("001 FSQL", "Builder (DELETE)", function(a_tester) {
      var queryObject1 = parser.parse("DELETE FROM proj WHERE id >= ${1} OR (id = ${1} AND proj.k <> z)", [200, 1]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("DELETE FROM proj1 WHERE id >= ${1}", [200, 1]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");
    });

    uniTest.add("001 FSQL", "Builder (UPDATE)", function(a_tester) {
      var queryObject1 = parser.parse("UPDATE proj SET field1 = ${1}, field2 = ${2} WHERE id=${3}", [200, 1, 3]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");
    });

    uniTest.add("001 FSQL", "Builder (UPDATE JOIN)", function(a_tester) {
      var queryObject1 = parser.parse("UPDATE proj LEFT JOIN table1 ON table1.ref = proj.id SET field1 = ${1}, field2 = ${2} WHERE id=${3}", [200, 1, 3]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");
    });


    uniTest.add("001 FSQL", "Builder (INSERT)", function(a_tester) {
      var queryObject1 = parser.parse("INSERT INTO proj (field1, field2) VALUES (${1}, ${2})", [200, 1]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");
    });

    uniTest.add("001 FSQL", "Builder (SELECT)", function(a_tester) {
      var queryObject1 = parser.parse("SELECT * FROM proj", []);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT *, field1 AS \"res 1\", field2 AS res2, function1(k1) AS func1 FROM proj", []);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1 FROM proj WHERE id = ${1}", [123]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1 FROM proj WHERE id = ${1} ORDER BY date ASC LIMIT ${2} OFFSET ${3}", [123, 10, 20]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1 FROM proj LEFT JOIN proj2 as left_join_proj2 ON left_join_proj2.parent = id WHERE id = ${1}", [123, 10, 20]);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1 FROM proj WHERE id = $[0][0][key]", []);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1->subfield FROM proj", []);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

      var queryObject1 = parser.parse("SELECT field1:default->subfield1->subfield2 FROM proj", []);
      var queryTxt = builder.build(queryObject1);
      var queryObject2 = parser.parse(queryTxt.query, queryTxt.args);
      uniTest.equalObject(queryObject1, queryObject2, "");

    });

    return NTests;
  }
});
