fcf.module({
  name: "fcf:tests/NFSQL/Parser.delete.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(uniTest, Parser) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();

    uniTest.add("001 FSQL", "Parser (DELETE)", function(a_tester) {

      var data = parser.parse("DELETE FROM proj WHERE id = ${1}", [2]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj',
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 2}]}],
        },
        "");

      var data = parser.parse("DELETE FROM \"proj2\" WHERE \"id\" <> ${1} ", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1} ", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1} LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          language: "en",
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"WHERE\"id\"<>${1}LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [{logic: "and", type: "<>", args:[{field: "id"}, {value: 3}]}],
          language: "en",
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\"LANGUAGE en", [3]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [],
          language: "en",
        },
        "");

      var data = parser.parse("DELETE FROM\"proj2\" LANGUAGE ${1}", ["en"]);
      uniTest.equalObject(
        data,
        {
          type: 'delete',
          from: 'proj2',
          where: [],
          language: "en",
        },
        "");

    });

    return NTests;
  }
});
