fcf.module({
  name: "fcf:tests/NFSQL/Parser.select.queryjoin.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js", "fcf:NFSQL/NDetails/SingleBuilder.js"],
  module: function(uniTest, Parser, SingleBuilder) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");

    uniTest.add("001 FSQL", "Parser (SELECT: query join)", function(a_tester) {
      var parser = new Parser();
      var builder = new SingleBuilder();

      var data = parser.parse("SELECT f1 as alias FROM proj JOIN (SELECT \"field1\" FROM tableX WHERE x=${1}) as jointable ON proj.lnk = jointable.id WHERE f1 = ${2}", [1, 2]);
      uniTest.equalObject(data,
        {
          "type": "select",
          "from": "proj",
          "fields": [ { "field": "f1", "as": "alias" } ],
          "join": [
            {
              "query": {
                "type": "select",
                "from": "tableX",
                "fields": [ { "field": "field1" } ],
                "join": [],
                "where": [{"logic": "and", "type": "=", "args": [{"field": "x"}, {"value": 1}]}],
                "order": [],
                "group": []
              },
              "as": "jointable",
              "on": [
                {
                  "logic": "and",
                  "args": [ { "field": "lnk", "from": "proj" }, { "field": "id", "from": "jointable" } ],
                  "type": "="
                }
              ]
            }
          ],
          "where": [ {
              "logic": "and",
              "args": [ { "field": "f1" }, { "value": 2 } ],
              "type": "="
            } ],
          "order": [],
          "group": []
        }
      );

      var query = builder.build(data);
      uniTest.equal(
        query.query,
        "SELECT \"f1\" AS \"alias\" FROM \"proj\" JOIN (SELECT \"field1\" FROM \"tableX\" WHERE \"x\" = ${1}) AS \"jointable\" ON \"proj\".\"lnk\" = \"jointable\".\"id\" WHERE \"f1\" = ${2}");
      uniTest.equal(query.args, [1,2]);
    });



    return NTests;
  }
});
