fcf.module({
  name: "fcf:tests/NFSQL/Parser.updateJoin.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(uniTest, Parser) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();

    uniTest.add("001 FSQL", "Parser (UPDATE Join)", function(a_tester) {

      var data = parser.parse("UPDATE proj LEFT JOIN projection2 AS proj2 ON proj2.id = proj.id SET f1 = ${1}, f2 = ${2} WHERE id = ${3}", [1, 2,100]);
      uniTest.equal(
        data,
        {
          "type": "update",
          "from": "proj",
          "values": [
            { "field": "f1", "value": 1 },
            { "field": "f2", "value": 2 }
          ],
          "where": [{
              "logic": "and",
              "args": [ { "field": "id" }, { "value": 100 } ],
              "type": "="
          }],
          "join": [ {
              "join": "left",
              "from": "projection2",
              "as": "proj2",
              "on": [ {
                  "logic": "and",
                  "args": [ { "field": "id", "from": "proj2" }, { "field": "id", "from": "proj" } ],
                  "type": "="
              } ]
            }
          ]
      });

      var data = parser.parse("UPDATE proj JOIN projection2 AS proj2 ON proj2.id = proj.id SET f1 = ${1}, f2 = ${2} WHERE id = ${3}", [1, 2,100]);
      uniTest.equal(
        data,
        {
          "type": "update",
          "from": "proj",
          "values": [
            { "field": "f1", "value": 1 },
            { "field": "f2", "value": 2 }
          ],
          "where": [{
              "logic": "and",
              "args": [ { "field": "id" }, { "value": 100 } ],
              "type": "="
          }],
          "join": [ {
              "join": "left",
              "from": "projection2",
              "as": "proj2",
              "on": [ {
                  "logic": "and",
                  "args": [ { "field": "id", "from": "proj2" }, { "field": "id", "from": "proj" } ],
                  "type": "="
              } ]
            }
          ]
      });

      var data = parser.parse('UPDATE proj JOIN "projection2" AS "proj2" ON proj2.id = proj.id SET f1 = ${1}, f2 = ${2} WHERE id = ${3}', [1, 2,100]);
      uniTest.equal(
        data,
        {
          "type": "update",
          "from": "proj",
          "values": [
            { "field": "f1", "value": 1 },
            { "field": "f2", "value": 2 }
          ],
          "where": [{
              "logic": "and",
              "args": [ { "field": "id" }, { "value": 100 } ],
              "type": "="
          }],
          "join": [ {
              "join": "left",
              "from": "projection2",
              "as": "proj2",
              "on": [ {
                  "logic": "and",
                  "args": [ { "field": "id", "from": "proj2" }, { "field": "id", "from": "proj" } ],
                  "type": "="
              } ]
            }
          ]
      });

      var data = parser.parse("UPDATE proj RIGHT JOIN projection2 AS proj2 ON proj2.id = proj.id LEFT JOIN proj3 ON proj3.id = proj.id SET f1 = ${1}, f2 = ${2} WHERE id = ${3}", [1, 2,100]);
      uniTest.equal(
        data,
        {
          "type": "update",
          "from": "proj",
          "values": [
            { "field": "f1", "value": 1 },
            { "field": "f2", "value": 2 }
          ],
          "where": [{
              "logic": "and",
              "args": [ { "field": "id" }, { "value": 100 } ],
              "type": "="
          }],
          "join": [
            {
              "join": "right", "from": "projection2", "as": "proj2",
              "on": [ {
                  "logic": "and",
                  "args": [ { "field": "id", "from": "proj2" }, { "field": "id", "from": "proj" } ],
                  "type": "="
              } ]
            },
            {
              "join": "left", "from": "proj3",
              "on": [ {
                  "logic": "and",
                  "args": [ { "field": "id", "from": "proj3" }, { "field": "id", "from": "proj" } ],
                  "type": "="
              } ]
            }

          ]
      });





    });

    return NTests;
  }
});
