#!/usr/local/bin/ruby
# -*- coding: utf-8 -*-
#
#= Atom Feed 1.0を管理するWEBアプリケーション
#
#Autohr::    Kureha Hisame (http://lunardial.sakura.ne.jp/) & Yui Naruse (http://airemix.com/)
#Version::   3.0.0.0
#Copyright:: Copyright 2009 FeedBlog Project (http://sourceforge.jp/projects/feedblog/)
#License::   GPLv3

# ログイン情報配列
LOGININFO = [
  {:id => "login", :password => "password", :name => "テストユーザ"}
]
# タグリスト
TAGS = [
  {:term => "music", :label => "音楽"},
  {:term => "game", :label => "ゲーム"},
  {:term => "circle", :label => "サークル"} 
]
# XMLファイル格納先までの相対パス
XMLPATH = "./../lunardial/xml/"
# FeedBlogを設置したディレクトリのURL
HOMEBASE = "https://lunardial.sakura.ne.jp/"
# 入力されたフルパスURL(HOMEBASE)を置換する文字列
RELAYPATH = "./"
# loglist.xmlファイルの定義
LISTXMLPATH = "#{XMLPATH}loglist.xml"
# FeedBlog上の表示ページからログ格納ディレクトリまでのパス
FEEDXMLDIR = "./xml/"
# デバッガモード
DEBUG = false
# ファイルマネージャー機能を使用するならtrue
USEFILEMANAGER = true
# ファイルマネージャー機能スクリプト(filemanager.rb)のパス
FILEMANAGER = "./filemanager.rb"
# XMLに書き込む際、改行部分を<br>のまま保持するか、改行記号に直すか
REPLACEBRTAG = false
# ファイルの書き込み時にENTRYのIDおよびURLを、FEEDオブジェクトから自動生成した値に置換するか否か
REPLACEENTRYIDANDURL = false
# プラグインディレクトリ
PLUGINDIR = "./plugins/"
# 記事用初期ファイル名
INITIALXML = "diary.xml"

# 画像フォルダの場所を定義
IMGPATH = "./../lunardial/xml/img/"
# アップロード可能な最大ファイルサイズ
UPLOADLIMIT = 2 * 1024 * 1024

# ログディレクトリ
LOG_DIR = "./logs/"
# 開発用ログを出力するか？
LOG_RELEASE_MODE = false

# ファイルマネージャ用設定
# サムネイル画像の最大幅（縦・横共通）を指定
THUMBS_SIZE = 150
# 必要がある場合はrubygems, rmagickのLOADPATHを指定
$LOAD_PATH.push("/home/lunardial/local/lib")
$LOAD_PATH.push("/home/lunardial/local/lib/ruby/gem/gems/rmagick-2.13.1/lib")

# バージョン情報を示す文字列です
APPVERSION = "- FeedGenerator for Ruby version 4.0.0.0 -<br>Copyright(c) 2009 Kureha.H (<a href=\"http://lunardial.sakura.ne.jp/\" target=\"_blank\">http://lunardial.sakura.ne.jp/</a>) & Yui Naruse (<a href=\"http://airemix.com/\" target=\"_blank\">http://airemix.com/</a>)"
# タイトル領域に表示される文字列です
APPTITLE = "FeedGenerator for Ruby version 4.0.0.0"


