unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.Ani, FMX.Layouts,
  FMX.Gestures,
  FMX.StdCtrls, FMX.ListView.Types, FMX.ListView, FMX.Controls.Presentation,
  FMX.Edit, FMX.EditBox, FMX.SpinBox, ShellAPI, Windows, FMX.Objects,
  IniFiles, FMX.Graphics;

type
  TForm1 = class(TForm)
    StyleBook1: TStyleBook;
    ListView1: TListView;
    SpinBox1: TSpinBox;
    Button2: TButton;
    procedure ListView1DragDrop(Sender: TObject; const Data: TDragObject;
      const Point: TPointF);
    procedure ListView1DragOver(Sender: TObject; const Data: TDragObject;
      const Point: TPointF; var Operation: TDragOperation);
    procedure Button2Click(Sender: TObject);
    procedure ListView1ButtonClick(const Sender: TObject;
      const AItem: TListViewItem; const AObject: TListItemSimpleControl);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure ListView1DblClick(Sender: TObject);
  private
    FDir: string;
    { private 錾 }
    procedure SearchDir(const Path: string);
    procedure SetDir(const Value: string);
  public
    { public 錾 }
    Level: Integer;
    property Dir: string read FDir write SetDir;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}
{$R *.Windows.fmx MSWINDOWS}

procedure TForm1.Button2Click(Sender: TObject);
begin
  ListView1.ClearItems;
  SearchDir(Dir);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  s: TIniFile;
begin
  s := TIniFile.Create(ChangeFileExt(Application.DefaultTitle, '.ini'));
  try
    FDir := s.ReadString('Directory', 'Current', '');
  finally
    s.Free;
  end;
  SearchDir(Dir);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  s: TIniFile;
begin
  s := TIniFile.Create(ChangeFileExt(Application.DefaultTitle, '.ini'));
  try
    s.WriteString('Directory', 'Current', Dir);
  finally
    s.Free;
  end;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  case Key of
    vkEscape:
      Close;
  end;
end;

procedure TForm1.ListView1ButtonClick(const Sender: TObject;
  const AItem: TListViewItem; const AObject: TListItemSimpleControl);
begin
  ShellExecute(ContextHandle, PChar('OPEN'), PChar(AItem.Detail), nil, nil,
    SW_SHOWNORMAL);
end;

procedure TForm1.ListView1DblClick(Sender: TObject);
begin
  case WindowState of
  TWindowState.wsNormal:
    WindowState := TWindowState.wsMaximized;
  TWindowState.wsMaximized:
    WindowState := TWindowState.wsNormal;
  end;
end;

procedure TForm1.ListView1DragDrop(Sender: TObject; const Data: TDragObject;
  const Point: TPointF);
begin
  if (Length(Data.Files) > 0)and(System.SysUtils.DirectoryExists(Data.Files[0]) = true) then
    Dir := Data.Files[0];
end;

procedure TForm1.ListView1DragOver(Sender: TObject; const Data: TDragObject;
  const Point: TPointF; var Operation: TDragOperation);
begin
  Operation := TDragOperation.Move;
end;

procedure TForm1.SearchDir(const Path: string);
var
  s: TSearchRec;
  i: Integer;
  t: TListViewItem;
begin
  i := FindFirst(Path + '\*.exe', faNormal, s);
  try
    while i = 0 do
    begin
      t := ListView1.Items.Add;
      t.Text := s.Name+' '+IntToStr(s.Size div 1000000)+'MB';
      t.Detail := Path + '\' + s.Name;
      t.ButtonText := 'N';
      // t.Bitmap.Handle:=ExtractAssociatedIcon(hInstance,PChar(t.Detail),0);
      i := FindNext(s);
    end;
  finally
    System.SysUtils.FindClose(s);
  end;
  inc(Level);
  i := FindFirst(Path + '\*', faDirectory, s);
  try
    while (i = 0) and (Level - 1 <= StrToInt(SpinBox1.Text)) do
    begin
      if Pos('.', s.Name) = 0 then
        SearchDir(Path + '\' + s.Name);
      i := FindNext(s);
    end;
  finally
    dec(Level);
    System.SysUtils.FindClose(s);
  end;
end;

procedure TForm1.SetDir(const Value: string);
begin
  FDir := Value;
  Showmessage('Dir=' + Value);
  ListView1.ClearItems;
  SearchDir(Value);
end;

end.
