#include "StdAfx.h"
#include "DBitmap.h"
#include "DRenderBase.h"

using namespace DWriteWarpper;

DBitmap::DBitmap(ID2D1Bitmap* brush)
{
	if(brush == NULL)
		throw gcnew ArgumentNullException("brush is NULL");
	brush_ = brush;
	disposed = false;
}
ID2D1Bitmap* DBitmap::bitmap::get()
{
	return this->brush_;
}

void DBitmap::CopyFromRenderTarget(Point2U dest,DRenderBase^ base,RectU srcRect)
{
	brush_->CopyFromRenderTarget(&D2D1::Point2U(dest.X,dest.Y),base->render,&D2D1::RectU(srcRect.Left,srcRect.Top,srcRect.Right,srcRect.Bottom));
}
DBitmap::~DBitmap()
{
	GC::SuppressFinalize(this);
	this->!DBitmap();
}
DBitmap::!DBitmap()
{
	if(disposed)
		return;
	int cRefCount = brush_->Release();
	disposed = true;
}
