#include "D3D9Device.h"

using namespace System;
using namespace DWriteWarpper;

D3D9Device::D3D9Device(void)
{
	IDirect3D9Ex* pD3d9;
	HRESULT hr;
	hr = Direct3DCreate9Ex(D3D_SDK_VERSION,&pD3d9);
	if(hr != S_OK)
		throw "Failed Direct3DCreate9Ex";
	this->d3d9 = pD3d9;

	HWND desktopWnd = GetDesktopWindow();

	IDirect3DDevice9Ex* pDevice;
	D3DPRESENT_PARAMETERS d3dpp;
	ZeroMemory( &d3dpp, sizeof(d3dpp) );
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.hDeviceWindow = desktopWnd;
	d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	d3d9->CreateDeviceEx(D3DADAPTER_DEFAULT,
		D3DDEVTYPE_HAL,
		desktopWnd,
		D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
		&d3dpp,
		NULL,
		&pDevice);
	this->device = pDevice;
}

D3D9Surface^ D3D9Device::CreateTexture(D2DTexture^ texture)
{
	if(texture == nullptr)
		throw "texture must not be null";

	HRESULT hr;

	IDXGIResource *resource;
	hr = texture->texture->QueryInterface(__uuidof(IDXGIResource), (LPVOID*)&resource);
    if(hr != S_OK)
		throw "Failed get DXGIResource";
	HANDLE sharedHandle;
	hr = resource->GetSharedHandle(&sharedHandle);
    if(hr != S_OK)
		throw "Failed GetSharedHandle";

	D3D10_TEXTURE2D_DESC desc;
	texture->texture->GetDesc(&desc);

	IDirect3DTexture9 *d3d9Texture;
	hr = this->device->CreateTexture(desc.Width,
		desc.Height,
		1,
		D3DUSAGE_RENDERTARGET,
		D3DFMT_A8R8G8B8,
		D3DPOOL_DEFAULT,
		&d3d9Texture,
		&sharedHandle);
	if(hr != S_OK)
		throw "Failed CreateTexture";

	IDirect3DSurface9* pSurface;
	hr = d3d9Texture->GetSurfaceLevel(0,&pSurface);
	if(hr != S_OK)
		throw "Failed GetSurfaceLevel";

	d3d9Texture-> Release();
	resource->Release();

	return gcnew D3D9Surface(pSurface);
}

D3D9Device::~D3D9Device(void)
{
	GC::SuppressFinalize(this);
	this->!D3D9Device();
}

D3D9Device::!D3D9Device()
{
	if(device != NULL)
	{
		this->device->Release();
		this->device = NULL;
	}
	if(d3d9 != NULL)
	{
		this->d3d9->Release();
		this->d3d9 = NULL;
	}
}