#include "DFactory.h"

using namespace DWriteWarpper;
using namespace System::ComponentModel;

DFactory::DFactory()
{
	disposed = false;

	_CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_WNDW);
	_CrtSetDbgFlag(_CRTDBG_LEAK_CHECK_DF | _CRTDBG_ALLOC_MEM_DF);

	HRESULT hr;


	ID2D1Factory* d2dfactory;
	// Create Direct2D factory.
	hr = D2D1CreateFactory(
			D2D1_FACTORY_TYPE_MULTI_THREADED,
			__uuidof(ID2D1Factory) ,
			reinterpret_cast<void**>(&d2dfactory)
			);
	this->pD2DFactory_ = d2dfactory;

	IDWriteFactory* pDWriteFactory;
	// Create a shared DirectWrite factory.
	if (SUCCEEDED(hr))
	{
		hr = DWriteCreateFactory(
			DWRITE_FACTORY_TYPE_SHARED,
			__uuidof(IDWriteFactory),
			reinterpret_cast<IUnknown**>(&pDWriteFactory)
			);
	}
	this->pDWriteFactory_ = pDWriteFactory;

	HDC screen = GetDC(0);
	dpiScaleX_ = GetDeviceCaps(screen, LOGPIXELSX) / 96.0f;
	dpiScaleY_ = GetDeviceCaps(screen, LOGPIXELSY) / 96.0f;
	ReleaseDC(0, screen);
}

DWindowRender^ DFactory::CreateWindowRender(IntPtr handel,bool vsync)
{
	HWND hwnd_ = (HWND)handel.ToPointer();

	HRESULT hr = S_OK;

	RECT rc;
	GetClientRect(
		hwnd_,
		&rc
		);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
	);

	HDC screen = GetDC(0);
	float dpiX = (float)GetDeviceCaps(screen, LOGPIXELSX);
	float dpiY = (float)GetDeviceCaps(screen, LOGPIXELSY);
	ReleaseDC(0, screen);

	D2D1_PIXEL_FORMAT pixelFormat = D2D1::PixelFormat(
		DXGI_FORMAT_B8G8R8A8_UNORM,
		D2D1_ALPHA_MODE_IGNORE
		);

	D2D1_RENDER_TARGET_PROPERTIES renderTargetProps = D2D1::RenderTargetProperties(
			D2D1_RENDER_TARGET_TYPE_DEFAULT,
			pixelFormat,
			dpiX,
			dpiY,
			D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE,
			D2D1_FEATURE_LEVEL_DEFAULT
		);
	D2D1_HWND_RENDER_TARGET_PROPERTIES hwndRenderTargetProps = D2D1::HwndRenderTargetProperties(
			hwnd_,
			size,
			vsync ? D2D1_PRESENT_OPTIONS_NONE : D2D1_PRESENT_OPTIONS_IMMEDIATELY
	);

	ID2D1HwndRenderTarget* pRT_;
	// Create a Direct2D render target.
	hr = pD2DFactory_->CreateHwndRenderTarget(
		&renderTargetProps,
		&hwndRenderTargetProps,
		&pRT_
		);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateHwndRenderTarget Failed");

	return gcnew DWindowRender(pRT_);
}

DRenderBase^ DFactory::CreateDxgiSurfaceRenderTarget(DXGISurface^ surface)
{
	HDC screen = GetDC(0);
	float dpiX = (float)GetDeviceCaps(screen, LOGPIXELSX);
	float dpiY = (float)GetDeviceCaps(screen, LOGPIXELSY);
	ReleaseDC(0, screen);

	HRESULT hr;

	D2D1_PIXEL_FORMAT pixelFormat = D2D1::PixelFormat(
		DXGI_FORMAT_UNKNOWN,
		D2D1_ALPHA_MODE_IGNORE
		);

	D2D1_RENDER_TARGET_PROPERTIES renderTargetProps = D2D1::RenderTargetProperties(
			D2D1_RENDER_TARGET_TYPE_DEFAULT,
			pixelFormat,
			dpiX,
			dpiY,
			D2D1_RENDER_TARGET_USAGE_NONE,
			D2D1_FEATURE_LEVEL_DEFAULT
		);
	ID2D1RenderTarget* render;
	hr = pD2DFactory_->CreateDxgiSurfaceRenderTarget(
		surface->surface,
		&renderTargetProps,
		&render);
	if(hr != S_OK)
		throw "Failed CreateDxgiSurfaceRenderTarget";
	return gcnew DRenderBase(render);
}

DTextFormat^ DFactory::CreateTextFormat(String^ fontName,float point)
{
	pin_ptr<const WCHAR> pstr = PtrToStringChars(fontName);

	HRESULT hr;
	IDWriteTextFormat *pTextFormat;
	float dpisize = Util::PointToDpiSize(point);
	hr = pDWriteFactory_->CreateTextFormat(
		pstr,
		NULL,
		DWRITE_FONT_WEIGHT_REGULAR,
		DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		dpisize,
		L"",
		&pTextFormat
		);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateTextFormat Error");

	return gcnew DTextFormat(pTextFormat);
}

DTextLayout^ DFactory::CreateTextLayout(DTextFormat^ format,String^ str,float width,float height)
{
	pin_ptr<const WCHAR> chars = PtrToStringChars(str);

	HRESULT hr;
		
	int length = wcslen(chars);

	IDWriteTextLayout* pTextLayout;

	hr = pDWriteFactory_->CreateTextLayout(
		chars,
		length,
		format->dwTextFormat,
		width,
		height,
		&pTextLayout
	);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateTextLayout Error");

	return gcnew DTextLayout(pTextLayout);
}

DTextLayout^ DFactory::CreateGdiTextLayout(DTextFormat^ format,String^ str,float width,float height,bool useGdiNatural)
{
	pin_ptr<const WCHAR> chars = PtrToStringChars(str);

	HRESULT hr;
		
	int length = wcslen(chars);

	IDWriteTextLayout* pTextLayout;

	hr = pDWriteFactory_->CreateGdiCompatibleTextLayout(
		chars,
		length,
		format->dwTextFormat,
		width,
		height,
		dpiScaleX_,
		NULL,
		useGdiNatural,
		&pTextLayout
	);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateGdiTextLayout Error");

	return gcnew DTextLayout(pTextLayout);
}

DStrokeStyle^ DFactory::CrateStrokeStyke(DLineStyle style)
{
	D2D1_STROKE_STYLE_PROPERTIES prop = D2D1::StrokeStyleProperties(
		D2D1_CAP_STYLE_FLAT,  // The start cap.
		D2D1_CAP_STYLE_FLAT,  // The end cap.
		D2D1_CAP_STYLE_TRIANGLE, // The dash cap.
		D2D1_LINE_JOIN_MITER, // The line join.
		10.0f, // The miter limit.
		D2D1_DASH_STYLE_SOLID, // The dash style.
		0.0f // The dash offset.
		);
			
	switch(style)
	{
		case DLineStyle::Solid:
			prop.dashStyle = D2D1_DASH_STYLE_SOLID;
			break;
		case DLineStyle::Dot:
			prop.dashStyle = D2D1_DASH_STYLE_DOT;
			break;
		case DLineStyle::Dash:
			prop.dashStyle = D2D1_DASH_STYLE_DASH;
			break;
		case DLineStyle::DashDot:
			prop.dashStyle = D2D1_DASH_STYLE_DASH_DOT;
			break;
		case DLineStyle::DashDotDot:
			prop.dashStyle = D2D1_DASH_STYLE_DASH_DOT_DOT;
			break;
	}

	HRESULT hr;
	ID2D1StrokeStyle* stroke;
	hr = pD2DFactory_->CreateStrokeStyle(prop,NULL,0,&stroke);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateStrokeStyle Error");

	return gcnew DStrokeStyle(stroke);
}

DRenderingParams^ DFactory::CreateMonitorRenderingParams(IntPtr hmonitor)
{
	HMONITOR monitor = (HMONITOR)hmonitor.ToPointer();
	IDWriteRenderingParams* pRenderingParams;
	HRESULT hr;
	hr = pDWriteFactory_->CreateMonitorRenderingParams(monitor, &pRenderingParams);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateMonitorRenderingParams");
	return gcnew DRenderingParams(pRenderingParams);
}

DFactory::~DFactory()
{
	GC::SuppressFinalize(this);
	this->!DFactory();
}

DFactory::!DFactory()
{
	if(disposed)
		return;
	if(DWriteWarpper::SafeRelease(pD2DFactory_))
		pD2DFactory_ = NULL;
	if(DWriteWarpper::SafeRelease(pDWriteFactory_))
		pDWriteFactory_ = NULL;
	disposed = true;
}
