#pragma once

#include "CustomTextRenderer.h"
#include "DColorBrush.h"
#include "DBitmap.h"
#include "DTextFormat.h"
#include "DTextLayout.h"
#include "DStrokeStyle.h"
#include "DRenderingParams.h"
#include "Util.h"
#include <vcclr.h>

using namespace System;

namespace DWriteWarpper {

    public value struct SizeU
    {
    public:
        SizeU(
            UINT32 width,
            UINT32 height
            )
		{
			this->Width = width;
			this->Height = height;
		}

        UINT32 Width;
        UINT32 Height;

        static Boolean operator == ( SizeU a, SizeU b )
        {
            return 
                (a.Width == b.Width)  &&
                (a.Height == b.Height);
        }

        static Boolean operator != ( SizeU a, SizeU b )
        {
            return !(a == b);
        }

    };

    public value struct Point2U
    {
    public:
        Point2U(
            UINT32 x,
            UINT32 y
            )
		{
			this->X = y;
			this->Y = y;
		}

        UINT32 X;
        UINT32 Y;

        static Boolean operator == ( Point2U a, Point2U b )
        {
            return 
                (a.X == b.X)  &&
                (a.Y == b.Y);
        }
        static Boolean operator != ( Point2U a, Point2U b )
        {
            return !(a == b);
        }
    };

    public value struct RectU
    {
    public:

        /// <summary>
        /// Constructor for the RectU value type
        /// </summary>
        /// <param name="left">Initializes the left field.</param>
        /// <param name="top">Initializes the top field.</param>
        /// <param name="right">Initializes the right field.</param>
        /// <param name="bottom">Initializes the bottom field.</param>
        RectU(
            UINT32 left,
            UINT32 top,
            UINT32 right,
            UINT32 bottom
            )
		{
			this->Left = left;
			this->Top = top;
			this->Right = right;
			this->Bottom = bottom;
		}


        UINT32 Left;
        UINT32 Top;
        UINT32 Right;
        UINT32 Bottom;

        property UINT32 Height
        {
            UINT32 get()
            {
                return static_cast<UINT32>(Math::Abs((int)(Bottom - Top)));
            }

            void set(UINT32 value)
            {
                Bottom = Top + value;
            }

        }

        property UINT32 Width
        {
            UINT32 get()
            {
                return static_cast<UINT32>(Math::Abs((int)(Left - Right)));
            }

            void set(UINT32 value)
            {
                Right = Left + value;
            }
        }

        static Boolean operator == ( RectU a, RectU b )
        {
            return 
                (a.Left == b.Left)  &&
                (a.Top == b.Top)  &&
                (a.Right == b.Right)  &&
                (a.Bottom == b.Bottom);
        }

        static Boolean operator != ( RectU a, RectU b )
        {
            return !(a == b);
        }
    };

    public value struct Point2F
    {
    public:
        Point2F(
            float x,
            float y
            )
		{
			this->X = x;
			this->Y = y;
		}

        float X;
        float Y;

        static Boolean operator == ( Point2F a, Point2F b )
        {
            return 
                (a.X == b.X)  &&
                (a.Y == b.Y);
        }

        static Boolean operator != ( Point2F a, Point2F b )
        {
            return !(a == b);
        }
    };

    public value struct SizeF
    {
    public:
        SizeF(
            float width,
            float height
            )
		{
			this->Width = width;
			this->Height = height;
		}

        float Width;
        float Height;

		static Boolean operator == ( SizeF a, SizeF b )
        {
            return 
                (a.Width == b.Width)  &&
                (a.Height == b.Height);
        }
        static Boolean operator != ( SizeF a, SizeF b )
        {
            return !(a == b);
        }
    };

    public value struct RectF
    {
    public:
        RectF(
            FLOAT left,
            FLOAT top,
            FLOAT right,
            FLOAT bottom
            )
		{
			this->Left = left;
			this->Top = top;
			this->Right = right;
			this->Bottom = bottom;
		}

        float Left;
        float Top;
        float Right;
        float Bottom;
        property FLOAT Height
        {
            FLOAT get()
            {
                return Math::Abs(Bottom - Top);
            }

            void set(FLOAT value)
            {
                Bottom = Top + value;
            }

        }
        property FLOAT Width
        {
            FLOAT get()
            {
                return Math::Abs(Left - Right);
            }

            void set(FLOAT value)
            {
                Right = Left + value;
            }
        }

        static Boolean operator == ( RectF a, RectF b )
        {
            return 
                (a.Left == b.Left)  &&
                (a.Top == b.Top)  &&
                (a.Right == b.Right)  &&
                (a.Bottom == b.Bottom);
        }

        static Boolean operator != ( RectF a, RectF b )
        {
            return !(a == b);
        }
    };

	public enum class DAntialias
	{
		Alias = D2D1_ANTIALIAS_MODE_ALIASED,
		Antialias = D2D1_ANTIALIAS_MODE_PER_PRIMITIVE,
	};

	public enum class DTextAntialias
	{
		Defalut = D2D1_TEXT_ANTIALIAS_MODE_DEFAULT,
		ClearType = D2D1_TEXT_ANTIALIAS_MODE_CLEARTYPE,
		GrayScale = D2D1_TEXT_ANTIALIAS_MODE_GRAYSCALE,
		Aliased = D2D1_TEXT_ANTIALIAS_MODE_ALIASED,
	};

	public enum class DDrawTextOptions
	{
		NoSnap = D2D1_DRAW_TEXT_OPTIONS_NO_SNAP,
		Clip = D2D1_DRAW_TEXT_OPTIONS_CLIP,
		None = D2D1_DRAW_TEXT_OPTIONS_NONE,
	};

	public ref class DRenderBase
	{
	private:
		bool disposed;
		ID2D1RenderTarget* pRT_;
		CustomTextRenderer* pTextRender_;
		DColorBrush^ _defalutFore;
		DColorBrush^ _controlFore;
	internal:
		DRenderBase(ID2D1RenderTarget* render);

		property ID2D1RenderTarget* render
		{
			ID2D1RenderTarget* get();
		}
	public:
		DRenderBase(void);

		property DAntialias AntialiasMode
		{
			DAntialias get();
			void set(DAntialias value);
		}

		property bool HasTextRender
		{
			bool get();
		}

		property DTextAntialias TextAntialiasMode
		{
			DTextAntialias get();
			void set(DTextAntialias value);
		}

		void SetDefalutBrush(DColorBrush^ defalutBrush);

		void SetControlBrush(DColorBrush^ controlBrush);

		void InitTextRender(DColorBrush^ defalutBrush,DColorBrush^ controlBrush);

		void PushAxisAlignedClip(RectF rect,DAntialias mode);

		void PopAxisAlignedClip();

		void BeginDraw();

		bool EndDraw();

		void Flush();

		DBitmap^ CreateBitmap(SizeU size);

		DColorBrush^ CreateBrush(Color2F color);

		void SetTextRenderingParams(DRenderingParams^ param);

		void DrawBitmap(DBitmap^ bmp,RectF dstRect,float opacity,RectF srcRect);

		void DrawText(String^ str,DTextFormat^ format,RectF rect,DColorBrush^ foreBrush);

		void DrawTextLayout(DTextLayout^ layout,float x,float y);

		void DrawTextLayout(DTextLayout^ layout,float x,float y,DColorBrush^ defaultForeBrush,DDrawTextOptions options);

		void DrawLine(Point2F from,Point2F to,float width,DColorBrush^ foreBrush,DStrokeStyle^ stroke);

		void FillRectangle(RectF rect,DColorBrush^ foreBrush);

		void Clear(Color2F color);

		virtual ~DRenderBase(void);

		void RemoveControlSymbol(System::Char c);

		void AddControlSymbol(System::Char c,unsigned int indic);

		!DRenderBase(void);
	};
}
