﻿using System;
using System.Text;
using System.Windows;
using System.Windows.Media;
using DWriteWarpper;
using System.Windows.Interop;

namespace Test2
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        D3D9Device device9;
        D3D9Surface surface9;
        D3D10Device device;
        D2DTexture texture;
        DXGISurface surface;
        DFactory factory;
        DRenderBase render;
        DTextFormat format;
        DColorBrush brush,control;
        StringBuilder buffer = new StringBuilder();

        public MainWindow()
        {
            InitializeComponent();

            this.CreateResource();

            this.TextInput += new System.Windows.Input.TextCompositionEventHandler(MainWindow_TextInput);
            this.Unloaded += new RoutedEventHandler(MainWindow_Unloaded);

            CompositionTarget.Rendering += new EventHandler(CompositionTarget_Rendering);
        }

        void MainWindow_TextInput(object sender, System.Windows.Input.TextCompositionEventArgs e)
        {
            this.buffer.Append(e.Text);
        }

        void CompositionTarget_Rendering(object sender, EventArgs e)
        {
            if (this.imageSource.IsFrontBufferAvailable)
            {
                this.imageSource.Lock();

                DTextLayout layout = factory.CreateTextLayout(this.format, this.buffer.ToString(), (float)image.Width, (float)image.Height);

                this.render.BeginDraw();
                //これを呼び出すと何も表示されなくなってしまう
                this.render.Clear(new Color2F(0, 255, 255, 128));
                //this.render.DrawTextLayout(layout, 10, 10,this.brush,DDrawTextOptions.None);
                this.render.DrawTextLayout(layout, 10, 10);
                this.render.EndDraw();

                this.device.Flush();

                layout.Dispose();

                this.imageSource.SetBackBuffer(D3DResourceType.IDirect3DSurface9, this.surface9.Handel);

                this.imageSource.AddDirtyRect(new Int32Rect(0, 0, (int)image.Width, (int)image.Height));
                
                this.imageSource.Unlock();

            }
        }

        void CreateResource()
        {
            this.device = new D3D10Device();
            this.texture = this.device.CreateTexture2D((int)image.Width, (int)image.Height);
            this.surface = new DXGISurface(this.texture);
            this.factory = new DFactory();
            this.render = factory.CreateDxgiSurfaceRenderTarget(this.surface);
            this.render.TextAntialiasMode = DTextAntialias.ClearType;
            this.format = factory.CreateTextFormat(this.FontFamily.Source, (float)this.FontSize);
            this.brush = this.render.CreateBrush(new Color2F(0, 0, 0, 255));
            this.control = this.render.CreateBrush(new Color2F(128, 128, 128, 255));
            this.render.InitTextRender(this.brush, this.control);
            this.render.AddControlSymbol('\r', 0x2193);
            this.render.AddControlSymbol('\t', 0x3e);
            this.render.AddControlSymbol((char)0x1a, 0xFFE9);
            this.render.AddControlSymbol('　', 0x25A1);
            this.device9 = new D3D9Device();
            this.surface9 = this.device9.CreateTexture(this.texture);
        }

        void DestructResource()
        {
            this.control.Dispose();
            this.brush.Dispose();
            this.format.Dispose();
            this.render.Dispose();
            this.factory.Dispose();
            this.surface.Dispose();
            this.texture.Dispose();
            this.device.Dispose();
            this.device9.Dispose();
            this.surface9.Dispose();
        }

        void MainWindow_Unloaded(object sender, RoutedEventArgs e)
        {
            this.DestructResource();
        }
    }
}
