#include <Windows.h>
#include "WPFHost.h"

using namespace FooProject::WPFHost;

LRESULT CALLBACK DummyWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_ERASEBKGND:
		return TRUE;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

WPFHost::WPFHost()
{
	WNDCLASSEX wcex = { sizeof(WNDCLASSEX) };
	wcex.style         = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc   = DummyWndProc;
	wcex.cbClsExtra    = 0;
	wcex.cbWndExtra    = sizeof(LONG_PTR);
	wcex.hInstance     = GetModuleHandle(L"WPFHost");
	wcex.hbrBackground = NULL;
	wcex.lpszMenuName  = NULL;
	wcex.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wcex.lpszClassName = L"D2DDemoApp";

	RegisterClassEx(&wcex);
}

HandleRef WPFHost::BuildWindowCore(HandleRef hwndParent)
{
	HWND Wnd = CreateWindowEx(0,
		L"D2DDemoApp",
		L"",
		WS_CHILD | WS_VISIBLE,
		0,0,
		1,1,
		(HWND)hwndParent.Handle.ToPointer(),
		NULL,
		NULL,
		0);
	return HandleRef(this,IntPtr(Wnd));
}

void WPFHost::DestroyWindowCore(HandleRef hwnd)
{
	DestroyWindow((HWND)hwnd.Handle.ToPointer());
}

System::Windows::Size WPFHost::MeasureOverride(System::Windows::Size constraint)
{
	HWND hwnd = (HWND)this->Handle.ToPointer();
	MoveWindow(hwnd,0,0,(int)constraint.Width,(int)constraint.Height,false);
	return constraint;
}

IntPtr WPFHost::WndProc (IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, bool% handled)
{
	switch(msg)
	{
	case WM_WINDOWPOSCHANGED:
		HWND hwnd = (HWND)this->Handle.ToPointer();
		HMONITOR monitor = MonitorFromWindow(hwnd, MONITOR_DEFAULTTONULL);
		if(monitor != this->currentMonitor)
		{
			this->currentMonitor = monitor;
			this->MoniterChanged(this,gcnew MonterEventArgs(IntPtr(monitor)));
		}
		break;
	}
	handled = false;
	return IntPtr::Zero;
}
