﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.TextFormatting;

namespace FooEditEngine.WPF
{
    class TextLayout :  IDisposable
    {
        List<TextLine> lines = new List<TextLine>();
        FontRendering fontRender;
        CustomTextSource textSource;
        double _width;
        public TextLayout(string s, FontFamily font, double fontSize,Brush fore,double width,TextAlignment align = TextAlignment.Left)
        {
            this.fontRender = new FontRendering(font, fontSize, fore, align);
            this.textSource = new CustomTextSource();
            this.textSource.Text = s;
            this.textSource.FontRendering = fontRender;
            this.textSource.EffectCollection = new TextEffectCollection();
            this.textSource.DecorationCollection = new List<TextDecorationInfo>();
            this._width = width;
        }

        public List<TextLine> Lines
        {
            get
            {
                this.CreateLine();
                return this.lines;
            }
        }

        public void SetTextEffect(TextEffect effect)
        {
            this.textSource.EffectCollection.Add(effect);
        }

        public void SetTextDecoration(int start, int count, TextDecorationCollection collection)
        {
            this.textSource.DecorationCollection.Add(new TextDecorationInfo(start, count, collection));
        }

        public void Draw(DrawingContext dc,double x,double y)
        {
            this.CreateLine();
            foreach(TextLine line in this.lines)
                line.Draw(dc,new System.Windows.Point(x,y),InvertAxes.None);
        }

        public void Dispose()
        {
            foreach (TextLine line in this.lines)
                line.Dispose();
            this.lines.Clear();
        }

        void CreateLine()
        {
            TextFormatter formatter = TextFormatter.Create();
            int textStorePosition = 0;
            this.lines.Clear();
            while (textStorePosition < textSource.Text.Length)
            {
                TextLine myTextLine = formatter.FormatLine(
                    textSource,
                    textStorePosition,
                    this._width,
                    new GenericTextParagraphProperties(fontRender),
                    null);
                lines.Add(myTextLine);
                textStorePosition += myTextLine.Length;
            }
        }
    }
}
