﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Drawing;
using FooEditEngine;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using DXGI = SharpDX.DXGI;
using System.Runtime.InteropServices;

namespace FooEditEngine.Windows
{

    class D2DTextRender : ITextRender, IDisposable
    {
        D2DRenderCommon common;
        FooTextBox TextBox;
        ColorTable _ColorTable = new ColorTable();

        public D2DTextRender(FooTextBox textbox)
        {
            this.TextBox = textbox;

            textbox.SizeChanged += new EventHandler(textbox_SizeChanged);
            textbox.FontChanged += new EventHandler(textbox_FontChanged);
            textbox.HandleCreated += new EventHandler(textbox_HandleCreated);
            textbox.HandleDestroyed += new EventHandler(textbox_HandleDestroyed);

            Size size = textbox.Size;
            this.common = new D2DRenderCommon(textbox, size.Width, size.Height);
            this.common.ConstructRender = ConstructRenderHandler;
            this.common.ConstrctedResource = ConstructedResourceHandler;
            this.common.DestructRender = this.DestructRenderHandler;
            this.common.ConstructDeviceResource(size.Width, size.Height);
            this.common.InitTextFormat(textbox.Font.Name, (float)textbox.Font.Size);
        }

        void textbox_HandleDestroyed(object sender, EventArgs e)
        {
            this.common.DestructDeviceResource();
        }

        void textbox_HandleCreated(object sender, EventArgs e)
        {
            FooTextBox textbox = (FooTextBox)sender;
            this.TextBox = textbox;
            this.common.ConstructDeviceResource(textbox.Width, textbox.Height);
        }

        void textbox_FontChanged(object sender, EventArgs e)
        {
            FooTextBox textbox = (FooTextBox)sender;
            this.common.InitTextFormat(textbox.Font.Name, textbox.Font.Size);
            if (this.ChangedRenderResource != null)
                ChangedRenderResource(this, null);
        }

        void textbox_SizeChanged(object sender, EventArgs e)
        {
            FooTextBox textbox = (FooTextBox)sender;
            this.WindowRender.Resize(new DrawingSize(textbox.Width, textbox.Height));
        }

        Color4 ToColor4(Color color)
        {
            return new Color4(color.R / 255.0f, color.G / 255.0f, color.B / 255.0f, color.A / 255.0f);
        }

        public ColorTable TokenToColor
        {
            get { return _ColorTable; }
            set
            {
                _ColorTable = value;
                this.common.ReConstructDeviceResource(this.TextBox.Width, this.TextBox.Height);
            }
        }

        public Rectangle ClipRect
        {
            get { return this.common.ClipRect; }
            set { this.common.ClipRect = value; }
        }

        public double LineNemberWidth
        {
            get
            {
                return this.common.LineNemberWidth;
            }
        }

        public int TabWidthChar
        {
            get { return this.common.TabWidthChar; }
            set
            {
                if (value == 0)
                    return;
                this.common.TabWidthChar = value;
            }
        }

        public bool ShowFullSpace
        {
            get
            {
                return this.common.ShowFullSpace;
            }
            set
            {
                this.common.ShowFullSpace = value;
            }
        }

        public bool ShowHalfSpace
        {
            get
            {
                return this.common.ShowHalfSpace;
            }
            set
            {
                this.common.ShowHalfSpace = value;
            }
        }

        public bool ShowTab
        {
            get
            {
                return this.common.ShowTab;
            }
            set
            {
                this.common.ShowTab = value;
            }
        }
        
        public event ChangedRenderResourceEventHandler ChangedRenderResource;

        public void ClearLayoutCache()
        {
            this.common.ClearLayoutCache();
        }

        public void DrawCachedBitmap(Rectangle rect)
        {
            this.common.DrawCachedBitmap(rect);
        }

        public void CacheContent()
        {
            this.common.CacheContent();
        }

        public bool IsVaildCache()
        {
            return this.common.IsVaildCache();
        }

        public void BeginDraw()
        {
            this.common.BegineDraw();
        }

        public void EndDraw()
        {
            this.common.EndDraw();
        }

        public void DrawLineNumber(int lineNumber, double x, double y)
        {
            this.common.DrawLineNumber(lineNumber, x, y);
        }

        public void DrawLineMarker(Rectangle rect)
        {
            this.common.DrawLineMarker(rect);
        }

        public void DrawCaret(Rectangle rect, bool transparent)
        {
            this.common.DrawCaret(rect, transparent);
        }

        public void FillBackground(Rectangle rect)
        {
            this.common.FillBackground(rect);
        }

        public void DrawOneLine(LineToIndexTable lti, int row, double x, double y, IEnumerable<Selection> SelectRanges, IEnumerable<Marker> MarkerRanges)
        {
            this.common.DrawOneLine(lti,
                row,
                x,
                y,
                SelectRanges,
                MarkerRanges,
                null);
        }

        public int GetIndexFromX(string str, double x)
        {
            return this.common.GetIndexFromX(str, x);
        }

        public double GetWidthFromIndex(string str, int index)
        {
            return this.common.GetWidthFromIndex(str, index);
        }

        public double GetWidth(string str)
        {
            return this.common.GetWidth(str);
        }

        public double GetXFromIndex(string str, int index)
        {
            return this.common.GetXFromIndex(str, index);
        }

        public double GetHeight(string str)
        {
            return this.common.GetHeight(str);
        }

        public int AlignIndexToNearestCluster(string str, int index, AlignDirection flow)
        {
            return this.common.AlignIndexToNearestCluster(str, index, flow);
        }

        public List<LineToIndexTableData> BreakLine(Document doc, int startIndex, int endIndex, double wrapwidth)
        {
            return this.BreakLine(doc, startIndex, endIndex, wrapwidth);
        }

        public void Dispose()
        {
            this.common.Dispose();
        }

        D2D.WindowRenderTarget WindowRender;

        D2D.RenderTarget ConstructRenderHandler(D2D.Factory factory, D2D.RenderTargetProperties prop, double width, double height)
        {
            D2D.HwndRenderTargetProperties hwndProp = new D2D.HwndRenderTargetProperties();
            hwndProp.Hwnd = this.TextBox.Handle;
            hwndProp.PixelSize = new DrawingSize(this.TextBox.Size.Width,this.TextBox.Size.Height);
            hwndProp.PresentOptions = D2D.PresentOptions.Immediately;
            this.WindowRender = new D2D.WindowRenderTarget(factory,prop,hwndProp);
            return this.WindowRender;
        }

        void ConstructedResourceHandler()
        {
            this.common.Foreground = this.ToColor4(this._ColorTable.Fore);
            this.common.Background = this.ToColor4(this._ColorTable.Back);
            this.common.ControlChar = this.ToColor4(this._ColorTable.Control);
            this.common.Url = this.ToColor4(this._ColorTable.URL);
            this.common.Keyword1 = this.ToColor4(this._ColorTable.Keyword1);
            this.common.Keyword2 = this.ToColor4(this._ColorTable.Keyword2);
            this.common.Literal = this.ToColor4(this._ColorTable.Literal);
            this.common.Comment = this.ToColor4(this._ColorTable.Comment);
            this.common.Hilight = this.ToColor4(this._ColorTable.Hilight);
            this.common.LineMarker = this.ToColor4(this._ColorTable.LineMarker);
            this.common.InsertCaret = this.ToColor4(this._ColorTable.InsertCaret);
            this.common.OverwriteCaret = this.ToColor4(this._ColorTable.OverwriteCaret); 
        }

        void DestructRenderHandler()
        {
            if (this.WindowRender != null)
                this.WindowRender.Dispose();
        }
    }
}
