﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using FooEditEngine;

namespace Test
{
    public class AppSettings
    {
        public static AppSettings _thisInstance = new AppSettings();
        public static AppSettings Current
        {
            get
            {
                if (_thisInstance._LineBreakMethodList == null)
                {
                    _thisInstance._LineBreakMethodList = new ObservableCollection<LineBreakMethodItem>();
                    _thisInstance._LineBreakMethodList.Add(new LineBreakMethodItem("折りたたまない", LineBreakMethod.None));
                    _thisInstance._LineBreakMethodList.Add(new LineBreakMethodItem("右端で折りたたむ", LineBreakMethod.PageBound));
                    _thisInstance._LineBreakMethodList.Add(new LineBreakMethodItem("50字で折りたたむ", LineBreakMethod.CharUnit));
                    _thisInstance._CurrentLineBreakMethod = _thisInstance._LineBreakMethodList[0];
                }
                return _thisInstance;
            }
        }

        bool _IsRTL, _ShowRuler, _ShowLineNumber, _ShowLineMarker, _HilightXML;
        ObservableCollection<LineBreakMethodItem> _LineBreakMethodList;
        LineBreakMethodItem _CurrentLineBreakMethod;

        public ObservableCollection<LineBreakMethodItem> LineBreakMethodList
        {
            get
            {
                return _LineBreakMethodList;
            }
        }

        public LineBreakMethodItem CurrentLineBreakMethod
        {
            get
            {
                return _CurrentLineBreakMethod;
            }
            set
            {
                this._CurrentLineBreakMethod = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool IsRTL
        {
            get
            {
                return _IsRTL;
            }
            set
            {
                _IsRTL = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }
        public bool ShowRuler
        {
            get
            {
                return _ShowRuler;
            }
            set
            {
                _ShowRuler = value;
                if(ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowLineNumber
        {
            get
            {
                return _ShowLineNumber;
            }
            set
            {
                _ShowLineNumber = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowLineMarker
        {
            get
            {
                return _ShowLineMarker;
            }
            set
            {
                _ShowLineMarker = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool HilightXML
        {
            get
            {
                return _HilightXML;
            }
            set
            {
                _HilightXML = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public event EventHandler ChangedSetting;
    }
    public struct LineBreakMethodItem
    {
        string _Title;
        LineBreakMethod _Method;
        public string Title
        {
            get
            {
                return this._Title;
            }
        }
        public LineBreakMethod Method
        {
            get
            {
                return this._Method;
            }
        }
        public LineBreakMethodItem(string title, LineBreakMethod method)
        {
            this._Title = title;
            this._Method = method;
        }
    }
}
