﻿using System;

namespace FooEditEngine
{
    /// <summary>
    /// トークンのタイプを表す
    /// </summary>
    public enum TokenType
    {
        None = 0,
        Keyword1,
        Keyword2,
        Comment,
        Literal,
        Control,
    }

    /// <summary>
    /// イベントデータを表す
    /// </summary>
    public class TokenSpilitEventArgs
    {
        /// <summary>
        /// 単語長
        /// </summary>
        public int length;
        /// <summary>
        /// トークンのタイプ
        /// </summary>
        public TokenType type;
        /// <summary>
        /// トークンの切り出しをやめるなら真をセットし、そうでないなら偽をセットする（規定値は偽）
        /// </summary>
        public bool breaked;
        /// <summary>
        /// トークンがあるインデックス
        /// </summary>
        public int index;

        /// <summary>
        /// コンストラクター
        /// </summary>
        public TokenSpilitEventArgs()
        {
        }

        /// <summary>
        /// コンストラクター
        /// </summary>
        /// <param name="index">開始インデックス</param>
        /// <param name="length">長さ</param>
        /// <param name="type">トークンタイプ</param>
        public TokenSpilitEventArgs(int index,int length, TokenType type)
        {
            this.length = length;
            this.type = type;
            this.index = index;
            this.breaked = false;
        }
    }

    /// <summary>
    /// トークンが切り出された時に呼ばれるイベント
    /// </summary>
    /// <param name="state">イベントデータ</param>
    /// <returns></returns>
    public delegate void TokenSpilitHandeler(TokenSpilitEventArgs state);

    /// <summary>
    /// シンタックスハイライトを行うためのインターフェイス
    /// </summary>
    public interface IHilighter
    {
        /// <summary>
        /// 初期状態に戻す
        /// </summary>
        void Reset();

        /// <summary>
        /// ハイライト処理を実行します
        /// </summary>
        /// <param name="text">対象となる文字列</param>
        /// <param name="length">文字列の長さ</param>
        /// <param name="action">トークンが切り出されたときに呼び出されるデリゲート</param>
        /// <returns>エンクロージャーレベル。開始エンクロージャーだけを検出した場合は1以上の値を返し、
        /// 終了エンクロージャーだけを検出した場合を-1以下の値を返すようにします。
        /// 何も検出しなかった場合、開始エンクロージャーと終了エンクロージャーが対になっている場合、
        /// エンクロージャー内で開始エンクロージャーを検出した場合は0を返します
        /// なお、開始エンクロージャーがすでに検出されている状態で検出したことを返した場合、その結果は無視されます
        /// </returns>
        int DoHilight(string text,int length, TokenSpilitHandeler action);
    }
}
