﻿using System;

namespace FooEditEngine
{
    class PrintableView : View
    {
        new IPrintableTextRender render;

        public PrintableView(Document doc,IPrintableTextRender r)
            : base (doc,r,0)
        {
            this.render = r;
        }

        public string Header
        {
            get;
            set;
        }

        public string Footer
        {
            get;
            set;
        }

        public new void Draw(Rectangle updateRect)
        {
            if (this.LayoutLines.Count == 0)
                return;

            if (this.Hilighter != null)
                this.Hilighter.Reset();

            Point pos = base.PageBound.Location;
            pos.X -= Src.X;
            double endposy = pos.Y + calcHeight(base.PageBound.Height);

            //ヘッダーを印刷する
            this.render.DrawString(this.Header, pos.X, pos.Y, StringAlignment.Center);

            pos.Y += (int)this.render.HeaderHeight;

            //レイアウト行を印刷する
            for (int i = Src.Row; pos.Y < endposy && i < this.LayoutLines.Count; i++)
            {
                var selectRange = GetIMarkerAtLine<Selection>(i, this.Document.Selections);

                var markerRange = GetIMarkerAtLine<Marker>(i, base.Document.Markers);

                this.render.DrawOneLine(this.LayoutLines,i, pos.X + this.render.LineNemberWidth, pos.Y, selectRange, markerRange);

                if (this.DrawLineNumber)
                    this.render.DrawLineNumber(i, this.PageBound.X, pos.Y);

                pos.Y += this.render.GetHeight(this.LayoutLines[i]);
            }

            //フッターを印刷する
            this.render.DrawString(this.Footer, pos.X, pos.Y, StringAlignment.Center);

            pos.Y += (int)this.render.FooterHeight;
        }

        public bool TryPageDown()
        {
            int RowNumInPage = calcDeltaRow(calcHeight(base.PageBound.Height));
            return base.TryScroll(this.Src.X, this.Src.Row + RowNumInPage);
        }

        int calcDeltaRow(double height)
        {
            double y = 0;
            for (int i = this.Src.Row; i < this.LayoutLines.Count; i++)
            {
                double lineHeight = this.render.GetHeight(this.LayoutLines[i]);
                if (y + lineHeight >= height)
                    return i - this.Src.Row;
                y += lineHeight;
            }
            return this.LayoutLines.Count - this.Src.Row;
        }

        double calcHeight(double pageHeight)
        {
            if (this.Footer != null && this.Footer != string.Empty)
                pageHeight -= (int)this.render.FooterHeight;
            if (this.Header != null && this.Header != string.Empty)
                pageHeight -= (int)this.render.HeaderHeight;
            return pageHeight;
        }
    }
}
