﻿using System;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Taskbar;
using FooEditEngine;
using FooEditor.Properties;

namespace FooEditor
{
    class TaskBar
    {
        private static TaskBar _instance;
        private TaskbarManager windowsTaskbar;
        private JumpList jumpList;

        private TaskBar()
        {
            Version version = Environment.Version;
            if (version.Major >= 6 && version.Minor >= 1)
            {
                this.windowsTaskbar = TaskbarManager.Instance;
                windowsTaskbar.ApplicationId = Resources.AppName;
            }
        }

        public static TaskBar GetInstance()
        {
            if (_instance == null)
                _instance = new TaskBar();
            return _instance;
        }

        public void SetProgressState(ProgressState state)
        {
            if (this.windowsTaskbar == null)
                return;
            switch (state)
            {
                case ProgressState.Start:
                    this.windowsTaskbar.SetProgressState(TaskbarProgressBarState.Indeterminate);
                    break;
                case ProgressState.Complete:
                    this.windowsTaskbar.SetProgressState(TaskbarProgressBarState.NoProgress);
                    break;
            }
        }

        public void InitJumpList()
        {
            if (this.windowsTaskbar == null)
                return;
            this.jumpList = JumpList.CreateJumpList();
            jumpList.KnownCategoryToDisplay = JumpListKnownCategoryType.Recent;
            jumpList.AddUserTasks(new JumpListLink(Application.ExecutablePath, Resources.NewJumlistLabel)
            {
                Arguments = "-new",
                IconReference = new Microsoft.WindowsAPICodePack.Shell.IconReference(Application.ExecutablePath, 0)
            });
            jumpList.Refresh();
        }
    }
}
