﻿using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using FooEditor;
using Microsoft.Win32;
using FooEditEngine;
using FooEditor.Plugin;
using FooEditEngine.WPF;

namespace Outline
{
    public static class OutlineCommands
    {
        public static RoutedCommand PasteAsChild = new RoutedCommand("PasteAsChild", typeof(OutlineWindow));
        public static RoutedCommand UpLevel = new RoutedCommand("UpLevel", typeof(OutlineWindow));
        public static RoutedCommand DownLevel = new RoutedCommand("DownLevel", typeof(OutlineWindow));
    }
    public class AnalyzePattern
    {
        public string Type;
        public string[] Patterns;
        public override string ToString()
        {
            return this.Type;
        }
        public AnalyzePattern(string type, string[] patterns)
        {
            this.Type = type;
            this.Patterns = patterns;
        }
    }
    /// <summary>
    /// OutlineWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class OutlineWindow : UserControl,IToolWindow
    {
        const string OutlineAnalyzePatternPath = Config.RegAppPath + "\\OutlineAnalyzePattern";
        DocumentWindow _Target;

        public OutlineWindow()
        {
            InitializeComponent();

            this.DataContext = this;

            this.realTimeAnalyze = true;
        }

        public bool IsActive
        {
            get { return (bool)GetValue(IsActiveProperty); }
            set { SetValue(IsActiveProperty, value); }
        }

        // Using a DependencyProperty as the backing store for IsActive.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty IsActiveProperty =
            DependencyProperty.Register("IsActive", typeof(bool), typeof(OutlineWindow), new PropertyMetadata(false));

        public string Title
        {
            get { return Properties.Resources.OutLineMenuName; }
        }

        public DocumentWindow Target
        {
            get { return this._Target; }
            set
            {
                this._Target = value;
                this._Target.TextBox.Document.Update += new FooEditEngine.DocumentUpdateEventHandler(Document_Update);
            }
        }

        public bool realTimeAnalyze
        {
            get;
            set;
        }

        public void ReGenerate()
        {
            FooTextBox textbox = this.Target.TextBox;
            OutlineAnalyzer.Analyze(this.TreeView, textbox.FoldingStrategy, textbox.LayoutLineCollection,textbox.Document);
        }
        
        private void treeView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.LeftButton == MouseButtonState.Pressed)
            {
                OutlineTreeItem item = (OutlineTreeItem)this.TreeView.SelectedItem;
                Actions.JumpNode(item, this.Target.TextBox);
            }
        }

        void Document_Update(object sender, DocumentUpdateEventArgs e)
        {
            if (this.realTimeAnalyze == false)
                return;
            FooTextBox textbox = this.Target.TextBox;
            if (textbox.FoldingStrategy is WZTextFoldingGenerator)
                textbox.LayoutLineCollection.GenerateFolding();
            OutlineAnalyzer.Analyze(this.TreeView, textbox.FoldingStrategy, textbox.LayoutLineCollection, textbox.Document);
        }
    }
}
