﻿using System;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;
using Windows.ApplicationModel.Resources;
using Windows.UI.Popups;
using Windows.UI.Xaml.Controls;
using System.Runtime.CompilerServices;
using EncodeDetect;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class PropertyFlyout : Page
    {
        PropertyFlyoutViewModel vm;

        public PropertyFlyout()
        {
            this.InitializeComponent();
        }

        public PropertyFlyout(DocumentControl document)
            : this()
        {
            this.vm = new PropertyFlyoutViewModel(document);
            this.FlyoutContent.DataContext = this.vm;
        }

    }
    class PropertyFlyoutViewModel : ViewModelBase
    {
        FileType _FileType;
        Encoding _Encode;
        LineFeedType _LineFeed;
        DocumentControl CurrentDocument;

        static ObservableCollection<Encoding> encodeCollection = new ObservableCollection<Encoding>();
        static ObservableCollection<LineFeedType> lineFeedCollection = new ObservableCollection<LineFeedType>();

        public PropertyFlyoutViewModel(DocumentControl document)
        {
            if (encodeCollection.Count == 0)
            {
                encodeCollection.Add(Encoding.GetEncoding("utf-32"));
                encodeCollection.Add(Encoding.GetEncoding("utf-32BE"));
                encodeCollection.Add(Encoding.GetEncoding("utf-16"));
                encodeCollection.Add(Encoding.GetEncoding("unicodeFFFE"));
                encodeCollection.Add(Encoding.GetEncoding("iso-2022-jp"));
                encodeCollection.Add(Encoding.GetEncoding("us-ascii"));
                encodeCollection.Add(Encoding.GetEncoding("euc-jp"));
                encodeCollection.Add(Encoding.GetEncoding("shift_jis"));
                encodeCollection.Add(new UTF8Encoding());
            }
            if (lineFeedCollection.Count == 0)
            {
                lineFeedCollection.Add(LineFeedType.CR);
                lineFeedCollection.Add(LineFeedType.CRLF);
                lineFeedCollection.Add(LineFeedType.LF);
            }
            this._FileType = document.DocumentType;
            this._Encode = document.Encode;
            this._LineFeed = document.LineFeed;

            this.SetFileType = document.SetDocumentType;

            this.SetEncode = async (enc) =>
            {
                ResourceLoader loader = new ResourceLoader();
                MessageDialog dialog = new MessageDialog(loader.GetString("ReloadMessage"));
                dialog.Commands.Add(new UICommand(loader.GetString("YesButton"), async (p) =>
                {
                    await this.CurrentDocument.ReloadFile(enc);
                }));
                dialog.Commands.Add(new UICommand(loader.GetString("NoButton"), (p) =>
                {
                    this.CurrentDocument.Encode = enc;
                }));
                await dialog.ShowAsync();
            };

            this.CurrentDocument = document;
        }

        Func<FileType,System.Threading.Tasks.Task> SetFileType;

        Func<Encoding,System.Threading.Tasks.Task> SetEncode;

        public FileType DocumentType
        {
            get
            {
                return this._FileType;
            }
            set
            {
                this._FileType = value;
                this.SetFileType(value);
                this.OnPropertyChanged();
            }
        }

        public Encoding Encode
        {
            get
            {
                return this._Encode;
            }
            set
            {
                this._Encode = value;
                this.SetEncode(value);
                this.OnPropertyChanged();
            }
        }

        public LineFeedType LineFeed
        {
            get
            {
                return this._LineFeed;
            }
            set
            {
                this._LineFeed = value;
                this.CurrentDocument.LineFeed = value;
                this.OnPropertyChanged();
            }
        }

        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return AppSettings.Current.FileTypeCollection;
            }
        }

        public ObservableCollection<Encoding> EncodeCollection
        {
            get
            {
                return encodeCollection;
            }
        }

        public ObservableCollection<LineFeedType> LineFeedCollection
        {
            get
            {
                return lineFeedCollection;
            }
        }
    }
}
