﻿using System.IO;
using System.Security.AccessControl;
using System.Security.Principal;
using System.Linq;

namespace FooEditor
{
    static class FileAccessPermissionHelper
    {
        // 書き込み権限持ってる？
        public static bool IsGotPermission(string path)
        {
            var rule = GetCurrentAccessRule(path);
            return ((rule != null) && ((rule.FileSystemRights & FileSystemRights.Write) == FileSystemRights.Write));
        }

        // 現在のユーザーが持っている指定パスのFileSystemAccessRuleを得る
        private static FileSystemAccessRule GetCurrentAccessRule(string path)
        {
            var fileSecurity = File.GetAccessControl(path);
            var rules = fileSecurity.GetAccessRules(true, true, typeof(SecurityIdentifier)).OfType<FileSystemAccessRule>();
            var currentIdentity = WindowsIdentity.GetCurrent();
            var sids = new[] { currentIdentity.User }.Concat(currentIdentity.Groups);

            // アクセスルール内にユーザーSIDがある？無ければグループSIDも探す
            return rules.FirstOrDefault((rule) =>
                {
                    return sids.Contains(rule.IdentityReference);
                });
        }
    }
}
