﻿using System;
using System.Windows.Forms;
using FooEditor.Properties;
using FooEditEngine;
using FooEditEngine.Windows;

namespace FooEditor
{
    public partial class LineJump : Form
    {
        FooTextBox fooTextBox;
        public LineJump()
        {
            InitializeComponent();
        }
        public LineJump(FooTextBox richtextbox)
        {
            this.fooTextBox = richtextbox;
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int lineno = Int32.Parse(this.textBox1.Text) - 1;   //UI上では０を入力することはない
            if (lineno > this.fooTextBox.LayoutLines.Count)
                throw new UserOperationException(Resources.OverflowMaxline);
            else if (lineno < 0)
                throw new UserOperationException(Resources.UnderflowLineNumber);
            this.fooTextBox.JumpCaret(lineno, 0);
            this.fooTextBox.Refresh();
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void LineJump_Load(object sender, EventArgs e)
        {
            int row = this.fooTextBox.LayoutLines.GetLineNumberFromIndex(this.fooTextBox.SelectionStart);
            row++;  //ＵＩ上では１から始まってる
            this.textBox1.Text = row.ToString();
        }
    }
}
