﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.ApplicationModel.Activation;
using Prism.Unity.Windows;
using Prism.Mvvm;
using Prism.Windows;
using FooEditor.UWP.Models;
using FooEditor.UWP.Services;
using FooEditor.UWP.Views;
using FooEditor.UWP.ViewModels;
using Microsoft.Practices.Unity;
using Microsoft.HockeyApp;
using Windows.Storage.AccessCache;
using System.Runtime.Serialization;
using Prism.Windows.Navigation;
using Prism.Windows.AppModel;

namespace FooEditor.UWP
{
    /// <summary>
    /// 既定の Application クラスを補完するアプリケーション固有の動作を提供します。
    /// </summary>
    sealed partial class App : PrismUnityApplication
    {
        /// <summary>
        /// 単一アプリケーション オブジェクトを初期化します。これは、実行される作成したコードの
        ///最初の行であるため、main() または WinMain() と論理的に等価です。
        /// </summary>
        public App()
        {
            this.InitializeComponent();

            //EncodeDetectを正常に動作させるために必要
            //http://www.atmarkit.co.jp/ait/articles/1509/30/news039.html
            System.Text.Encoding.RegisterProvider(System.Text.CodePagesEncodingProvider.Instance);

            ExtendedSplashScreenFactory = (splashscreen) => new ExtendedSplashScreen(splashscreen);

#if !DEBUG
            Microsoft.HockeyApp.HockeyClient.Current.Configure("7fc70d1f9bf64da7b9f2aa49d827b0fe").SetExceptionDescriptionLoader(ex => ex.ToString());
#endif
        }

        protected override Task OnInitializeAsync(IActivatedEventArgs args)
        {
            ViewModelLocationProvider.Register(
                typeof(MainPage).ToString(),
                () => {
                    return new MainPageViewModel(NavigationService, new MainViewService());
                } 
                );
            return base.OnInitializeAsync(args);
        }

        protected override Task OnLaunchApplicationAsync(LaunchActivatedEventArgs args)
        {
            if (!args.PrelaunchActivated)
            {
                NavigationService.Navigate("Main", null);
            }
            return Task.FromResult<object>(null);
        }

        protected override Task OnActivateApplicationAsync(IActivatedEventArgs args)
        {
            var fileargs = args as FileActivatedEventArgs;
            if (fileargs != null)
            {
                var filepaths = from file in fileargs.Files
                                select file.Path;

                //MRUに追加しないと後で開けない
                foreach (var file in fileargs.Files)
                    StorageApplicationPermissions.MostRecentlyUsedList.Add(file, "mrufile");

                //そのまま渡すと中断時に落ちるので文字列に変換する
                ObjectToXmlConverter conv = new ObjectToXmlConverter();

                NavigationService.Navigate("Main", conv.Convert(filepaths.ToArray(), typeof(string[]), null, null));
            }
            else
            {
                NavigationService.Navigate("Main", null);
            }
            return Task.FromResult<object>(null);
        }

        protected override void OnFileActivated(FileActivatedEventArgs args)
        {
            this.OnActivated(args);
        }
    }
}
