﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Threading.Tasks;
using System.Windows.Input;
using Windows.ApplicationModel.Store;
using Windows.Storage;
using Windows.Storage.AccessCache;
using Windows.Storage.Pickers;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace FooEditor
{
    class DocumentCollectionHelper
    {
        public static async Task AddFromFile(DocumentCollection collection, StorageFile file)
        {
            if (file != null)
            {
                if (collection.ActiveDocument(file.Name))
                    return;

                DocumentControl doc = new DocumentControl();
                doc.Title = file.Name;

                DocumentPageInfo info = new DocumentPageInfo(doc);
                collection.AddDocument(info);
                collection.ActiveDocument(info);

                await doc.LoadFile(new FileModel(file));
                StorageApplicationPermissions.MostRecentlyUsedList.Add(file, "mrufile");
            }
        }

        public static async Task AddFromFilePicker(DocumentCollection collection)
        {
            FileOpenPicker openPicker = new FileOpenPicker();

            openPicker.ViewMode = PickerViewMode.List;

            openPicker.FileTypeFilter.Add("*");

            openPicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            StorageFile file = await openPicker.PickSingleFileAsync();
            if (file != null)
            {
                await DocumentCollectionHelper.AddFromFile(collection, file);
            }
        }
    }
}
